/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.client.render.entity.ShaderMinecartRenderer;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageMinecartShaderSync
implements IMessage {
    private final int entityID;
    private final ItemStack shader;

    public MessageMinecartShaderSync(Entity entity, CapabilityShader.ShaderWrapper wrapper) {
        this.entityID = entity.m_19879_();
        this.shader = wrapper.getShaderItem();
    }

    public MessageMinecartShaderSync(Entity entity) {
        this.entityID = entity.m_19879_();
        this.shader = ItemStack.f_41583_;
    }

    public MessageMinecartShaderSync(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.shader = buf.m_130267_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.m_130055_(this.shader);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ServerLevel world = Objects.requireNonNull(ctx.getSender()).m_284548_();
            ctx.enqueueWork(() -> {
                Entity entity = world.m_6815_(this.entityID);
                if (entity == null) {
                    return;
                }
                CapabilityShader.ShaderWrapper cap = CapabilityUtils.getCapability((ICapabilityProvider)entity, CapabilityShader.SHADER_CAPABILITY);
                if (cap != null) {
                    ImmersiveEngineering.packetHandler.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)world).m_46472_()), (Object)new MessageMinecartShaderSync(entity, cap));
                }
            });
        } else {
            ctx.enqueueWork(() -> {
                Entity entity;
                Level world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (entity = world.m_6815_(this.entityID)) instanceof AbstractMinecart) {
                    ShaderMinecartRenderer.shadedCarts.put(this.entityID, (Object)this.shader);
                }
            });
        }
    }
}

