/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.energy.WindmillBiome;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class WindmillBiomeSerializer
extends IERecipeSerializer<WindmillBiome> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.WoodenDevices.WINDMILL);
    }

    @Override
    public WindmillBiome readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        int temperature = json.get("modifier").getAsInt();
        if (json.has("singleBiome")) {
            ResourceLocation biomeName = new ResourceLocation(json.get("singleBiome").getAsString());
            Biome singleBiome = (Biome)Preconditions.checkNotNull((Object)((Biome)ForgeRegistries.BIOMES.getValue(biomeName)));
            return new WindmillBiome(recipeId, (List<Biome>)ImmutableList.of((Object)singleBiome), (float)temperature);
        }
        ResourceLocation tagName = new ResourceLocation(json.get("biomeTag").getAsString());
        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagName);
        return new WindmillBiome(recipeId, (TagKey<Biome>)tag, (float)temperature);
    }

    @Nullable
    public WindmillBiome fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        boolean isTags = buffer.readBoolean();
        if (isTags) {
            ResourceLocation tagName = buffer.m_130281_();
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagName);
            return new WindmillBiome(recipeId, (TagKey<Biome>)tag, buffer.readFloat());
        }
        List<Biome> biomes = PacketUtils.readList(buffer, buf -> (Biome)buf.readRegistryIdUnsafe(ForgeRegistries.BIOMES));
        return new WindmillBiome(recipeId, biomes, buffer.readFloat());
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull WindmillBiome recipe) {
        if (recipe.biomes.isLeft()) {
            buffer.writeBoolean(true);
            buffer.m_130085_(recipe.biomes.leftNonnull().f_203868_());
        } else {
            buffer.writeBoolean(false);
            PacketUtils.writeList(buffer, recipe.biomes.rightNonnull(), (b, buf) -> buf.writeRegistryIdUnsafe(ForgeRegistries.BIOMES, b));
        }
        buffer.writeFloat(recipe.getModifier());
    }
}

