/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class MetalPressRecipeSerializer
extends IERecipeSerializer<MetalPressRecipe> {
    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.METAL_PRESS.iconStack();
    }

    @Override
    public MetalPressRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        Lazy<ItemStack> output = MetalPressRecipeSerializer.readOutput(json.get("result"));
        IngredientWithSize input = IngredientWithSize.deserialize(json.get("input"));
        Item mold = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"mold")));
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        return IEServerConfig.MACHINES.metalPressConfig.apply(new MetalPressRecipe(recipeId, output, input, mold, energy));
    }

    @Nullable
    public MetalPressRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Lazy<ItemStack> output = MetalPressRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        Item mold = (Item)buffer.readRegistryIdSafe(Item.class);
        int energy = buffer.readInt();
        return new MetalPressRecipe(recipeId, output, input, mold, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, MetalPressRecipe recipe) {
        MetalPressRecipeSerializer.writeLazyStack(buffer, recipe.output);
        recipe.input.write(buffer);
        buffer.writeRegistryId(ForgeRegistries.ITEMS, (Object)recipe.mold);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

