/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.DirectProcessingItemHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.MetalPressShapes;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipes;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.IESounds;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MetalPressLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final float TRANSLATION_DISTANCE = 2.5f;
    private static final float STANDARD_TRANSPORT_TIME = 20.0f;
    private static final float STANDARD_PRESS_TIME = 3.75f;
    private static final float MIN_CYCLE_TIME = 60.0f;
    public static final BlockPos REDSTONE_POS = new BlockPos(1, 0, 0);
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(3, 1, 0, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition INPUT_POS = new CapabilityPosition(0, 1, 0, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(1, 2, 0, RelativeBlockFace.UP);

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.renderAsActive) {
            return;
        }
        BlockPos soundPos = context.getLevel().toAbsolute(REDSTONE_POS);
        Level level = context.getLevel().getRawLevel();
        for (MultiblockProcess<MetalPressRecipe, ProcessContext.ProcessContextInWorld<MetalPressRecipe>> process : state.processor.getQueue()) {
            float maxTicks = process.getMaxTicks(level);
            float transportTime = MetalPressLogic.getTransportTime(maxTicks);
            float pressTime = MetalPressLogic.getPressTime(maxTicks);
            float fProcess = process.processTick;
            Player localPlayer = ImmersiveEngineering.proxy.getClientPlayer();
            if (fProcess >= transportTime && fProcess < transportTime + 1.0f) {
                level.m_5594_(localPlayer, soundPos, (SoundEvent)IESounds.metalpress_piston.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            if (fProcess >= transportTime + pressTime && fProcess < transportTime + pressTime + 1.0f) {
                level.m_5594_(localPlayer, soundPos, (SoundEvent)IESounds.metalpress_smash.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            if (fProcess >= maxTicks - transportTime && fProcess < maxTicks - transportTime + 1.0f) {
                level.m_5594_(localPlayer, soundPos, (SoundEvent)IESounds.metalpress_piston.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            ++process.processTick;
        }
    }

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean active = state.processor.tickServer(state, context.getLevel(), state.rsState.isEnabled(context));
        if (active != state.renderAsActive) {
            state.renderAsActive = active;
            context.requestMasterBESync();
        }
    }

    @Override
    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity entity) {
        Level world = ctx.getLevel().getRawLevel();
        if (world.f_46443_ || !INPUT_POS.posInMultiblock().equals((Object)posInMultiblock)) {
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (entity.m_6084_() && !itemEntity.m_32055_().m_41619_()) {
                SpecialMetalPressProcess process;
                ItemStack stack = itemEntity.m_32055_();
                if (stack.m_41619_()) {
                    return;
                }
                State state = ctx.getState();
                MetalPressRecipe recipe = MetalPressRecipe.findRecipe(state.mold, stack, world);
                if (recipe == null) {
                    return;
                }
                ItemStack displayStack = recipe.getDisplayStack(stack);
                if (recipe instanceof MetalPressPackingRecipes.RecipeDelegate) {
                    MetalPressPackingRecipes.RecipeDelegate delegate = (MetalPressPackingRecipes.RecipeDelegate)recipe;
                    process = new SpecialMetalPressProcess(delegate, displayStack);
                } else {
                    process = new MultiblockProcessInWorld(recipe, displayStack);
                }
                if (state.processor.addProcessToQueue(process, world, false)) {
                    ItemStack remaining = stack.m_41777_();
                    remaining.m_41774_(displayStack.m_41613_());
                    itemEntity.m_32045_(remaining);
                    if (remaining.m_41619_()) {
                        entity.m_146870_();
                    }
                }
            }
        }
    }

    @Override
    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        State state = ctx.getState();
        Level level = ctx.getLevel().getRawLevel();
        ItemStack heldItem = player.m_21120_(hand);
        ItemStack newMold = null;
        if (player.m_6144_() && !state.mold.m_41619_()) {
            newMold = ItemStack.f_41583_;
        } else if (MetalPressRecipe.isValidMold(level, heldItem)) {
            newMold = heldItem;
        }
        if (newMold == null) {
            return InteractionResult.FAIL;
        }
        ItemStack oldMold = state.mold;
        state.mold = ItemHandlerHelper.copyStackWithSize((ItemStack)newMold, (int)1);
        newMold.m_41774_(1);
        if (!oldMold.m_41619_()) {
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, oldMold);
            } else if (!isClient) {
                player.m_5552_(oldMold, 0.0f);
            }
        }
        ctx.markMasterDirty();
        ctx.requestMasterBESync();
        return InteractionResult.SUCCESS;
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && INPUT_POS.equals(position)) {
            return ctx.getState().inputCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.ENERGY && ENERGY_POS.equalsOrNullFace(position)) {
            return ctx.getState().energyCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        if (!state.mold.m_41619_()) {
            drop.accept(state.mold.m_41777_());
        }
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return MetalPressShapes.SHAPE_GETTER;
    }

    public static float getTransportTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 20.0f;
        }
        return processMaxTicks * 20.0f / 60.0f;
    }

    public static float getPressTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 3.75f;
        }
        return processMaxTicks * 3.75f / 60.0f;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInWorld<MetalPressRecipe> {
        public ItemStack mold = ItemStack.f_41583_;
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final MultiblockProcessor<MetalPressRecipe, ProcessContext.ProcessContextInWorld<MetalPressRecipe>> processor;
        private boolean renderAsActive;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final DroppingMultiblockOutput output;
        private final StoredCapability<IItemHandler> inputCap;
        private final StoredCapability<IEnergyStorage> energyCap = new StoredCapability<AveragingEnergyStorage>(this.energy);

        public State(IInitialMultiblockContext<State> ctx) {
            this.processor = new MultiblockProcessor(3, maxTicks -> 1.0f - (MetalPressLogic.getTransportTime(maxTicks) + MetalPressLogic.getPressTime(maxTicks)) / (float)maxTicks, 3, ctx.getMarkDirtyRunnable(), ctx.getSyncRunnable(), MetalPressRecipe.STANDARD_RECIPES::getById);
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.inputCap = new StoredCapability<DirectProcessingItemHandler<MetalPressRecipe>>(new DirectProcessingItemHandler<MetalPressRecipe>(ctx.levelSupplier(), this.processor, (level, input) -> MetalPressRecipe.findRecipe(this.mold, input, level)));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            this.writeCommonNBT(nbt);
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.readCommonNBT(nbt);
            nbt.m_128365_("energy", this.energy.serializeNBT());
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            this.writeCommonNBT(nbt);
            nbt.m_128379_("active", this.renderAsActive);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.readCommonNBT(nbt);
            this.renderAsActive = nbt.m_128471_("active");
        }

        private void writeCommonNBT(CompoundTag nbt) {
            if (!this.mold.m_41619_()) {
                nbt.m_128365_("mold", (Tag)this.mold.m_41739_(new CompoundTag()));
            }
            nbt.m_128365_("processor", this.processor.toNBT());
        }

        private void readCommonNBT(CompoundTag nbt) {
            this.mold = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("mold"));
            this.processor.fromNBT(nbt.m_128423_("processor"), State::loadProcess);
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public void doProcessOutput(ItemStack result, IMultiblockLevel level) {
            this.output.insertOrDrop(result, level);
        }

        public static MultiblockProcessInWorld<MetalPressRecipe> loadProcess(BiFunction<Level, ResourceLocation, MetalPressRecipe> getRecipe, CompoundTag tag) {
            if (tag.m_128425_("baseRecipe", 8)) {
                return new SpecialMetalPressProcess(tag, new ResourceLocation(tag.m_128461_("baseRecipe")));
            }
            return new MultiblockProcessInWorld<MetalPressRecipe>(getRecipe, tag);
        }
    }

    private static class SpecialMetalPressProcess
    extends MultiblockProcessInWorld<MetalPressRecipe> {
        private final ResourceLocation baseRecipeLocation;

        public SpecialMetalPressProcess(CompoundTag data, ResourceLocation baseRecipeLocation) {
            super((Level level, ResourceLocation name) -> {
                CraftingRecipe baseRecipe = MetalPressPackingRecipes.CRAFTING_RECIPE_MAP.getById((Level)level, baseRecipeLocation);
                if (baseRecipe != null) {
                    return MetalPressPackingRecipes.getRecipeDelegate(baseRecipe, name, level.m_9598_());
                }
                return null;
            }, data);
            this.baseRecipeLocation = baseRecipeLocation;
        }

        public SpecialMetalPressProcess(MetalPressPackingRecipes.RecipeDelegate recipe, ItemStack inputItem) {
            super(recipe, inputItem);
            this.baseRecipeLocation = recipe.baseRecipe.m_6423_();
        }

        @Override
        public void writeExtraDataToNBT(CompoundTag nbt) {
            super.writeExtraDataToNBT(nbt);
            nbt.m_128359_("baseRecipe", this.baseRecipeLocation.toString());
        }
    }
}

