/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.BucketWheelLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.ExcavatorShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ExcavatorLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final Set<CapabilityPosition> ENERGY_INPUTS = Set.of(new CapabilityPosition(2, 0, 4, RelativeBlockFace.LEFT), new CapabilityPosition(2, 1, 4, RelativeBlockFace.LEFT), new CapabilityPosition(2, 2, 4, RelativeBlockFace.LEFT));
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 5);
    private static final MultiblockFace ITEM_OUTPUT = new MultiblockFace(1, 1, 6, RelativeBlockFace.BACK);
    public static final BlockPos WHEEL_CENTER = new BlockPos(1, 1, 1);
    private static final Vec3 WHEEL_CENTER_TOP = Vec3.m_82512_((Vec3i)WHEEL_CENTER.m_6630_(2));
    private static final Vec3 DIG_POSITION = Vec3.m_82512_((Vec3i)WHEEL_CENTER.m_6625_(3));
    private static final Vec3 HOPPER = Vec3.m_82512_((Vec3i)WHEEL_CENTER.m_7494_().m_122024_());
    private static final List<BlockPos> DIG_POSITIONS = (List)Util.m_137537_(() -> {
        BlockPos belowWheelCenter = WHEEL_CENTER.m_7918_(0, -4, 0);
        return List.of(belowWheelCenter, belowWheelCenter.m_7918_(0, 0, 1), belowWheelCenter.m_7918_(0, 0, 2), belowWheelCenter.m_7918_(0, 0, -1), belowWheelCenter.m_7918_(0, 0, -2), belowWheelCenter.m_7918_(1, 0, 1), belowWheelCenter.m_7918_(-1, 0, 1), belowWheelCenter.m_7918_(1, 0, 0), belowWheelCenter.m_7918_(-1, 0, 0), belowWheelCenter.m_7918_(1, 0, -1), belowWheelCenter.m_7918_(-1, 0, -1));
    });

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(0.5, 1.5, 1.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.active, context.isValid(), soundPos, IESounds.oreConveyor, 0.125f);
        }
    }

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        float rot;
        IMultiblockLevel level = context.getLevel();
        State state = context.getState();
        int target = -1;
        IMultiblockBEHelperMaster<BucketWheelLogic.State> wheelHelper = ExcavatorLogic.getWheel(level);
        if (wheelHelper == null) {
            return;
        }
        BucketWheelLogic.State wheel = wheelHelper.getState();
        IMultiblockContext<BucketWheelLogic.State> wheelCtx = wheelHelper.getContext();
        this.adjustWheel(level.getOrientation(), wheelCtx.getLevel().getOrientation(), wheel);
        if (wheel.active != state.active) {
            wheel.active = state.active;
            wheelCtx.markDirtyAndSync();
            context.requestMasterBESync();
        }
        if ((rot = wheel.rotation) % 45.0f > 40.0f) {
            target = Math.round(rot / 360.0f * 8.0f) % 8;
        }
        if (!state.rsState.isEnabled(context)) {
            state.active = false;
            return;
        }
        Level rawLevel = level.getRawLevel();
        MineralVein mineralVein = ExcavatorHandler.getRandomMineral(rawLevel, level.toAbsolute(WHEEL_CENTER));
        MineralMix mineral = mineralVein != null ? mineralVein.getMineral(rawLevel) : null;
        int consumed = (Integer)IEServerConfig.MACHINES.excavator_consumption.get();
        int extracted = state.energy.extractEnergy(consumed, true);
        if (extracted < consumed) {
            state.active = false;
            return;
        }
        state.energy.extractEnergy(consumed, false);
        state.active = true;
        if (target >= 0) {
            boolean wheelChanged = false;
            int targetDown = (target + 4) % 8;
            if (((ItemStack)wheel.digStacks.get(targetDown)).m_41619_()) {
                ItemStack blocking = this.digBlocksInTheWay(level);
                if (!blocking.m_41619_()) {
                    wheel.digStacks.set(targetDown, (Object)blocking);
                    wheelChanged = true;
                } else if (mineral != null) {
                    if (this.fillBucket(mineralVein, mineral, level.toAbsolute(WHEEL_CENTER), wheel, targetDown, level)) {
                        wheelChanged = true;
                    }
                    mineralVein.deplete();
                }
            }
            if (!((ItemStack)wheel.digStacks.get(target)).m_41619_()) {
                state.output.insertOrDrop(((ItemStack)wheel.digStacks.get(target)).m_41777_(), level);
                Block b = Block.m_49814_((Item)((ItemStack)wheel.digStacks.get(target)).m_41720_());
                if (b != Blocks.f_50016_) {
                    this.spawnParticles((ItemStack)wheel.digStacks.get(target), level);
                    rawLevel.m_6263_(null, level.toAbsolute((Vec3)ExcavatorLogic.HOPPER).f_82479_, level.toAbsolute((Vec3)ExcavatorLogic.HOPPER).f_82480_, level.toAbsolute((Vec3)ExcavatorLogic.HOPPER).f_82481_, (SoundEvent)IESounds.oreDump.get(), SoundSource.BLOCKS, 0.875f, 1.0f);
                }
                wheel.digStacks.set(target, (Object)ItemStack.f_41583_);
                wheelChanged = true;
            }
            if (wheelChanged) {
                wheelCtx.markDirtyAndSync();
            }
        }
    }

    private void adjustWheel(MultiblockOrientation excavatorOrientation, MultiblockOrientation wheelOrientation, BucketWheelLogic.State wheel) {
        Direction wheelFront = wheelOrientation.front().m_122428_();
        wheel.reverseRotation = wheelFront != excavatorOrientation.front();
    }

    private void spawnParticles(ItemStack stack, IMultiblockLevel level) {
        if (!((Boolean)IEServerConfig.MACHINES.excavator_particles.get()).booleanValue()) {
            return;
        }
        Level level2 = level.getRawLevel();
        if (!(level2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel rawLevel = (ServerLevel)level2;
        Direction facing = level.getOrientation().front();
        Direction.Axis axis = facing.m_122434_();
        int sign = level.getOrientation().mirrored() ? 1 : -1;
        Vec3 topCenterAbs = level.toAbsolute(WHEEL_CENTER_TOP);
        double fixPosOffset = 0.5 * (double)sign * (double)facing.m_122421_().m_122540_();
        double fixVelOffset = 0.075 * (double)sign * (double)facing.m_122421_().m_122540_();
        for (int i = 0; i < 16; ++i) {
            double mX = (rawLevel.f_46441_.m_188500_() - 0.5) * 0.01;
            double mY = rawLevel.f_46441_.m_188500_() * -0.05;
            double mZ = (rawLevel.f_46441_.m_188500_() - 0.5) * 0.01;
            double rndPosOffset = 0.2 * (rawLevel.f_46441_.m_188500_() - 0.5);
            if (axis == Direction.Axis.Z) {
                mX += fixVelOffset;
            } else {
                mZ += fixVelOffset;
            }
            rawLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), topCenterAbs.f_82479_ + axis.m_6150_(rndPosOffset, 0.0, fixPosOffset), topCenterAbs.f_82480_, topCenterAbs.f_82481_ + axis.m_6150_(fixPosOffset, 0.0, rndPosOffset), 32, mX, mY, mZ, 0.075);
        }
    }

    @Nullable
    private static IMultiblockBEHelperMaster<BucketWheelLogic.State> getWheel(IMultiblockLevel level) {
        BlockEntity blockEntity = level.getBlockEntity(WHEEL_CENTER);
        if (!(blockEntity instanceof MultiblockBlockEntityMaster)) {
            return null;
        }
        MultiblockBlockEntityMaster wheelBE = (MultiblockBlockEntityMaster)blockEntity;
        IMultiblockBEHelper helper = wheelBE.getHelper();
        if (helper.getState() instanceof BucketWheelLogic.State) {
            return helper;
        }
        return null;
    }

    private ItemStack digBlocksInTheWay(IMultiblockLevel level) {
        for (BlockPos attemptPos : DIG_POSITIONS) {
            ItemStack dug = this.digBlock(attemptPos, level);
            if (dug.m_41619_()) continue;
            return dug;
        }
        return ItemStack.f_41583_;
    }

    private ItemStack digBlock(BlockPos relativePos, IMultiblockLevel level) {
        Level rawLevel = level.getRawLevel();
        if (!(rawLevel instanceof ServerLevel)) {
            return ItemStack.f_41583_;
        }
        ServerLevel serverLevel = (ServerLevel)rawLevel;
        FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer(rawLevel);
        BlockState blockstate = level.getBlockState(relativePos);
        Block block = blockstate.m_60734_();
        BlockPos absolutePos = level.toAbsolute(relativePos);
        if (!blockstate.m_60795_() && blockstate.m_60800_((BlockGetter)rawLevel, absolutePos) != -1.0f) {
            if (!block.canHarvestBlock(blockstate, (BlockGetter)rawLevel, absolutePos, (Player)fakePlayer)) {
                return ItemStack.f_41583_;
            }
            if (block.onDestroyedByPlayer(blockstate, rawLevel, absolutePos, (Player)fakePlayer, true, blockstate.m_60819_())) {
                block.m_6786_((LevelAccessor)rawLevel, absolutePos, blockstate);
                ItemStack tool = new ItemStack((ItemLike)Items.f_42385_);
                tool.m_41663_(Enchantments.f_44985_, 1);
                LootParams.Builder dropContext = new LootParams.Builder(serverLevel).m_287289_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)absolutePos)).m_287289_(LootContextParams.f_81463_, (Object)tool);
                List itemsNullable = blockstate.m_287290_(dropContext);
                NonNullList items = NonNullList.m_122779_();
                items.addAll((Collection)itemsNullable);
                for (int i = 0; i < items.size(); ++i) {
                    if (i == 0) continue;
                    ItemEntity ei = new ItemEntity(EntityType.f_20461_, rawLevel);
                    ei.m_32045_(((ItemStack)items.get(i)).m_41777_());
                    ei.m_146884_(Vec3.m_82512_((Vec3i)absolutePos));
                    rawLevel.m_7967_((Entity)ei);
                }
                rawLevel.m_46796_(2001, absolutePos, Block.m_49956_((BlockState)blockstate));
                if (items.size() > 0) {
                    return (ItemStack)items.get(0);
                }
            }
        }
        return ItemStack.f_41583_;
    }

    private boolean fillBucket(MineralVein mineralVein, MineralMix mineralMix, BlockPos wheelPos, BucketWheelLogic.State wheel, int targetDown, IMultiblockLevel level) {
        if (mineralVein.isDepleted()) {
            return false;
        }
        ItemStack ore = mineralMix.getRandomOre(ApiUtils.RANDOM);
        if (ore.m_41619_()) {
            return false;
        }
        if (ApiUtils.RANDOM.nextFloat() < mineralMix.failChance || (double)ApiUtils.RANDOM.nextFloat() < mineralVein.getFailChance(wheelPos)) {
            wheel.digStacks.set(targetDown, (Object)mineralMix.getRandomSpoil(ApiUtils.RANDOM));
        } else {
            wheel.digStacks.set(targetDown, (Object)ore);
        }
        Item item = ((ItemStack)wheel.digStacks.get(targetDown)).m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            level.getRawLevel().m_6263_(null, level.toAbsolute((Vec3)ExcavatorLogic.DIG_POSITION).f_82479_, level.toAbsolute((Vec3)ExcavatorLogic.DIG_POSITION).f_82480_, level.toAbsolute((Vec3)ExcavatorLogic.DIG_POSITION).f_82481_, blockItem.m_40614_().m_49966_().m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ENERGY && (position.side() == null || ENERGY_INPUTS.contains(position))) {
            return ctx.getState().energyCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public static int computeComparatorValue(State state, IMultiblockLevel level) {
        if (ExcavatorLogic.getWheel(level) == null) {
            return 0;
        }
        BlockPos wheelPos = level.toAbsolute(WHEEL_CENTER);
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(level.getRawLevel(), wheelPos);
        if (info == null) {
            return 0;
        }
        if (ExcavatorHandler.mineralVeinYield == 0) {
            return 15;
        }
        long totalDepletion = 0L;
        List<Pair<MineralVein, Integer>> veins = info.getAllVeins();
        if (veins.isEmpty()) {
            return 0;
        }
        for (Pair<MineralVein, Integer> pair : veins) {
            totalDepletion += (long)((MineralVein)pair.getFirst()).getDepletion();
        }
        float remain = (float)((long)ExcavatorHandler.mineralVeinYield - (totalDepletion /= (long)veins.size())) / (float)ExcavatorHandler.mineralVeinYield;
        return Mth.m_14167_((float)(Math.max(remain, 0.0f) * 15.0f));
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return ExcavatorShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState {
        private boolean active = false;
        private final MutableEnergyStorage energy = new MutableEnergyStorage(64000);
        private final StoredCapability<IEnergyStorage> energyCap = new StoredCapability<MutableEnergyStorage>(this.energy);
        private final DroppingMultiblockOutput output;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private BooleanSupplier isPlayingSound = () -> false;

        public State(IInitialMultiblockContext<State> ctx) {
            this.output = new DroppingMultiblockOutput(ITEM_OUTPUT, ctx);
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
        }

        public IEnergyStorage getEnergy() {
            return this.energy;
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

