/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectorProbeBlockEntity
extends ConnectorRedstoneBlockEntity {
    public DyeColor redstoneChannelSending = DyeColor.WHITE;
    public int outputThreshold = 0;
    private int lastOutput = 0;
    private static final Map<Direction.Axis, VoxelShape> SHAPES = (Map)Util.m_137469_(new EnumMap(Direction.Axis.class), map -> {
        float wMin = 0.28125f;
        float wMax = 0.71875f;
        map.put(Direction.Axis.X, Shapes.m_83048_((double)0.0, (double)0.28125, (double)0.28125, (double)1.0, (double)0.71875, (double)0.71875));
        map.put(Direction.Axis.Y, Shapes.m_83048_((double)0.28125, (double)0.0, (double)0.28125, (double)0.71875, (double)1.0, (double)0.71875));
        map.put(Direction.Axis.Z, Shapes.m_83048_((double)0.28125, (double)0.28125, (double)0.0, (double)0.71875, (double)0.71875, (double)1.0));
    });

    public ConnectorProbeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ConnectorRedstoneBlockEntity>)((BlockEntityType)IEBlockEntities.CONNECTOR_PROBE.get()), pos, state);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.f_58857_.m_46467_() % 8L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 7)) {
            int out = this.getComparatorSignal();
            int n = out = out >= this.outputThreshold ? out : 0;
            if (out != this.lastOutput) {
                this.lastOutput = out;
                this.rsDirty = true;
            }
        }
    }

    @Override
    public boolean isRSInput() {
        return true;
    }

    @Override
    public boolean isRSOutput() {
        return true;
    }

    private int getComparatorSignal() {
        BlockPos pos = this.m_58899_().m_121945_(this.getFacing());
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60807_()) {
            return state.m_60674_(this.f_58857_, pos);
        }
        if (state.m_60796_((BlockGetter)this.f_58857_, pos)) {
            ItemFrame entityitemframe;
            state = this.f_58857_.m_8055_(pos = pos.m_121945_(this.getFacing()));
            if (state.m_60807_()) {
                return state.m_60674_(this.f_58857_, pos);
            }
            if (state.m_60795_() && (entityitemframe = this.findItemFrame(this.f_58857_, this.getFacing(), pos)) != null) {
                return entityitemframe.m_31824_();
            }
        }
        return 0;
    }

    private ItemFrame findItemFrame(Level world, Direction facing, BlockPos pos) {
        List list = world.m_6443_(ItemFrame.class, new AABB(pos), entity -> entity != null && entity.m_6350_() == facing);
        return list.size() == 1 ? (ItemFrame)list.get(0) : null;
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        signals[this.redstoneChannelSending.ordinal()] = (byte)this.lastOutput;
        this.rsDirty = false;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.f_58857_.f_46443_) {
            ImmersiveEngineering.proxy.openTileScreen("redstoneprobe", this);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.m_128441_("redstoneChannel")) {
            this.redstoneChannel = DyeColor.m_41053_((int)message.m_128451_("redstoneChannel"));
        }
        if (message.m_128441_("redstoneChannelSending")) {
            this.redstoneChannelSending = DyeColor.m_41053_((int)message.m_128451_("redstoneChannelSending"));
        }
        if (message.m_128441_("outputThreshold")) {
            this.outputThreshold = message.m_128451_("outputThreshold");
        }
        this.updateAfterConfigure();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128405_("redstoneChannelSending", this.redstoneChannelSending.m_41060_());
        nbt.m_128405_("outputThreshold", this.outputThreshold);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.redstoneChannelSending = DyeColor.m_41053_((int)nbt.m_128451_("redstoneChannelSending"));
        this.outputThreshold = nbt.m_128451_("outputThreshold");
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().m_122424_();
        double conRadius = type.getRenderDiameter() / 2.0;
        return new Vec3(0.5 + (double)side.m_122429_() * (0.375 - conRadius), 0.5 + (double)side.m_122430_() * (0.375 - conRadius), 0.5 + (double)side.m_122431_() * (0.375 - conRadius));
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.getFacing().m_122434_());
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (!Utils.isScrewdriver(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return null;
        }
        return new Component[]{Component.m_237110_((String)"desc.immersiveengineering.info.redstoneChannel.rec", (Object[])new Object[]{I18n.m_118938_((String)("item.minecraft.firework_star." + this.redstoneChannel.m_41065_()), (Object[])new Object[0])}), Component.m_237110_((String)"desc.immersiveengineering.info.redstoneChannel.send", (Object[])new Object[]{I18n.m_118938_((String)("item.minecraft.firework_star." + this.redstoneChannelSending.m_41065_()), (Object[])new Object[0])})};
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }
}

