/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.mdast.mdx;

import guideme.libs.mdast.MdastContext;
import guideme.libs.mdast.MdastContextProperty;
import guideme.libs.mdast.MdastExtension;
import guideme.libs.mdast.mdx.ParseEntities;
import guideme.libs.mdast.mdx.model.MdxJsxAttribute;
import guideme.libs.mdast.mdx.model.MdxJsxAttributeNode;
import guideme.libs.mdast.mdx.model.MdxJsxExpressionAttribute;
import guideme.libs.mdast.mdx.model.MdxJsxFlowElement;
import guideme.libs.mdast.mdx.model.MdxJsxTextElement;
import guideme.libs.mdast.model.MdAstParent;
import guideme.libs.mdast.model.MdAstPosition;
import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.ParseException;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.Token;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class MdxMdastExtension {
    private static final MdastContextProperty<List<Tag>> TAG_STACK = new MdastContextProperty();
    private static final MdastContextProperty<Tag> TAG = new MdastContextProperty();
    public static final MdastExtension INSTANCE = MdastExtension.builder().canContainEol("mdxJsxTextElement").enter("mdxJsxFlowTag", MdxMdastExtension::enterMdxJsxTag).enter("mdxJsxFlowTagClosingMarker", MdxMdastExtension::enterMdxJsxTagClosingMarker).enter("mdxJsxFlowTagAttribute", MdxMdastExtension::enterMdxJsxTagAttribute).enter("mdxJsxFlowTagExpressionAttribute", MdxMdastExtension::enterMdxJsxTagExpressionAttribute).enter("mdxJsxFlowTagAttributeValueLiteral", MdxMdastExtension::buffer).enter("mdxJsxFlowTagAttributeValueExpression", MdxMdastExtension::buffer).enter("mdxJsxFlowTagSelfClosingMarker", MdxMdastExtension::enterMdxJsxTagSelfClosingMarker).enter("mdxJsxTextTag", MdxMdastExtension::enterMdxJsxTag).enter("mdxJsxTextTagClosingMarker", MdxMdastExtension::enterMdxJsxTagClosingMarker).enter("mdxJsxTextTagAttribute", MdxMdastExtension::enterMdxJsxTagAttribute).enter("mdxJsxTextTagExpressionAttribute", MdxMdastExtension::enterMdxJsxTagExpressionAttribute).enter("mdxJsxTextTagAttributeValueLiteral", MdxMdastExtension::buffer).enter("mdxJsxTextTagAttributeValueExpression", MdxMdastExtension::buffer).enter("mdxJsxTextTagSelfClosingMarker", MdxMdastExtension::enterMdxJsxTagSelfClosingMarker).exit("mdxJsxFlowTagClosingMarker", MdxMdastExtension::exitMdxJsxTagClosingMarker).exit("mdxJsxFlowTagNamePrimary", MdxMdastExtension::exitMdxJsxTagNamePrimary).exit("mdxJsxFlowTagNameMember", MdxMdastExtension::exitMdxJsxTagNameMember).exit("mdxJsxFlowTagNameLocal", MdxMdastExtension::exitMdxJsxTagNameLocal).exit("mdxJsxFlowTagExpressionAttribute", MdxMdastExtension::exitMdxJsxTagExpressionAttribute).exit("mdxJsxFlowTagExpressionAttributeValue", MdxMdastExtension::data).exit("mdxJsxFlowTagAttributeNamePrimary", MdxMdastExtension::exitMdxJsxTagAttributeNamePrimary).exit("mdxJsxFlowTagAttributeNameLocal", MdxMdastExtension::exitMdxJsxTagAttributeNameLocal).exit("mdxJsxFlowTagAttributeValueLiteral", MdxMdastExtension::exitMdxJsxTagAttributeValueLiteral).exit("mdxJsxFlowTagAttributeValueLiteralValue", MdxMdastExtension::data).exit("mdxJsxFlowTagAttributeValueExpression", MdxMdastExtension::exitMdxJsxTagAttributeValueExpression).exit("mdxJsxFlowTagAttributeValueExpressionValue", MdxMdastExtension::data).exit("mdxJsxFlowTagSelfClosingMarker", MdxMdastExtension::exitMdxJsxTagSelfClosingMarker).exit("mdxJsxFlowTag", MdxMdastExtension::exitMdxJsxTag).exit("mdxJsxTextTagClosingMarker", MdxMdastExtension::exitMdxJsxTagClosingMarker).exit("mdxJsxTextTagNamePrimary", MdxMdastExtension::exitMdxJsxTagNamePrimary).exit("mdxJsxTextTagNameMember", MdxMdastExtension::exitMdxJsxTagNameMember).exit("mdxJsxTextTagNameLocal", MdxMdastExtension::exitMdxJsxTagNameLocal).exit("mdxJsxTextTagExpressionAttribute", MdxMdastExtension::exitMdxJsxTagExpressionAttribute).exit("mdxJsxTextTagExpressionAttributeValue", MdxMdastExtension::data).exit("mdxJsxTextTagAttributeNamePrimary", MdxMdastExtension::exitMdxJsxTagAttributeNamePrimary).exit("mdxJsxTextTagAttributeNameLocal", MdxMdastExtension::exitMdxJsxTagAttributeNameLocal).exit("mdxJsxTextTagAttributeValueLiteral", MdxMdastExtension::exitMdxJsxTagAttributeValueLiteral).exit("mdxJsxTextTagAttributeValueLiteralValue", MdxMdastExtension::data).exit("mdxJsxTextTagAttributeValueExpression", MdxMdastExtension::exitMdxJsxTagAttributeValueExpression).exit("mdxJsxTextTagAttributeValueExpressionValue", MdxMdastExtension::data).exit("mdxJsxTextTagSelfClosingMarker", MdxMdastExtension::exitMdxJsxTagSelfClosingMarker).exit("mdxJsxTextTag", MdxMdastExtension::exitMdxJsxTag).build();

    private MdxMdastExtension() {
    }

    private static void buffer(MdastContext context, Token token) {
        context.buffer();
    }

    private static void data(MdastContext context, Token token) {
        context.getExtension().enter.get("data").handle(context, token);
        context.getExtension().exit.get("data").handle(context, token);
    }

    private static void enterMdxJsxTag(MdastContext context, Token token) {
        Tag tag = new Tag(token);
        if (!context.has(TAG_STACK)) {
            context.set(TAG_STACK, new ArrayList());
        }
        context.set(TAG, tag);
        context.buffer();
    }

    private static void enterMdxJsxTagClosingMarker(MdastContext context, Token token) {
        List<Tag> stack = MdxMdastExtension.getStack(context);
        if (stack.isEmpty()) {
            throw new ParseException("Unexpected closing slash `/` in tag, expected an open tag first", token.start, token.end, "mdast-util-mdx-jsx:unexpected-closing-slash");
        }
    }

    private static void enterMdxJsxTagAnyAttribute(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        if (tag.close) {
            throw new ParseException("Unexpected attribute in closing tag, expected the end of the tag", token.start, token.end, "mdast-util-mdx-jsx:unexpected-attribute");
        }
    }

    private static void enterMdxJsxTagSelfClosingMarker(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        if (tag.close) {
            throw new ParseException("Unexpected self-closing slash `/` in closing tag, expected the end of the tag", token.start, token.end, "mdast-util-mdx-jsx:unexpected-self-closing-slash");
        }
    }

    private static void exitMdxJsxTagClosingMarker(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        tag.close = true;
    }

    private static void exitMdxJsxTagNamePrimary(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        tag.name = context.sliceSerialize(token);
    }

    private static void exitMdxJsxTagNameMember(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        tag.name = tag.name + "." + context.sliceSerialize(token);
    }

    private static void exitMdxJsxTagNameLocal(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        tag.name = tag.name + ":" + context.sliceSerialize(token);
    }

    private static void enterMdxJsxTagAttribute(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        MdxMdastExtension.enterMdxJsxTagAnyAttribute(context, token);
        tag.attributes.add(new MdxJsxAttribute());
    }

    private static void enterMdxJsxTagExpressionAttribute(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        MdxMdastExtension.enterMdxJsxTagAnyAttribute(context, token);
        tag.attributes.add(new MdxJsxExpressionAttribute());
        context.buffer();
    }

    private static void exitMdxJsxTagExpressionAttribute(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        MdxJsxExpressionAttribute tail = (MdxJsxExpressionAttribute)tag.attributes.get(tag.attributes.size() - 1);
        tail.value = context.resume();
    }

    private static void exitMdxJsxTagAttributeNamePrimary(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        MdxJsxAttribute node = (MdxJsxAttribute)tag.attributes.get(tag.attributes.size() - 1);
        node.name = context.sliceSerialize(token);
    }

    private static void exitMdxJsxTagAttributeNameLocal(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        MdxJsxAttribute node = (MdxJsxAttribute)tag.attributes.get(tag.attributes.size() - 1);
        node.name = node.name + ":" + context.sliceSerialize(token);
    }

    private static void exitMdxJsxTagAttributeValueLiteral(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        String value = ParseEntities.parseEntities(context.resume());
        MdxJsxAttributeNode lastAttr = tag.attributes.get(tag.attributes.size() - 1);
        if (lastAttr instanceof MdxJsxAttribute) {
            MdxJsxAttribute attribute = (MdxJsxAttribute)lastAttr;
            attribute.setValue(value);
        } else if (lastAttr instanceof MdxJsxExpressionAttribute) {
            MdxJsxExpressionAttribute attribute = (MdxJsxExpressionAttribute)lastAttr;
            attribute.value = value;
        } else {
            throw new IllegalStateException();
        }
    }

    private static void exitMdxJsxTagAttributeValueExpression(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        MdxJsxAttribute tail = (MdxJsxAttribute)tag.attributes.get(tag.attributes.size() - 1);
        tail.setExpression(context.resume());
    }

    private static void exitMdxJsxTagSelfClosingMarker(MdastContext context, Token token) {
        Tag tag = MdxMdastExtension.getTag(context);
        tag.selfClosing = true;
    }

    private static void exitMdxJsxTag(MdastContext context, Token token) {
        Tag tail;
        Tag tag = MdxMdastExtension.getTag(context);
        List<Tag> stack = MdxMdastExtension.getStack(context);
        Tag tag2 = tail = stack.isEmpty() ? null : stack.get(stack.size() - 1);
        if (tag.close && !Objects.equals(tail.name, tag.name)) {
            throw new ParseException("Unexpected closing tag `" + MdxMdastExtension.serializeAbbreviatedTag(tag) + "`, expected corresponding closing tag for `" + MdxMdastExtension.serializeAbbreviatedTag(tail) + "` (" + MdAstPosition.stringify(tail.position()) + ")", token.start, token.end, "mdast-util-mdx-jsx:end-tag-mismatch");
        }
        context.resume();
        if (tag.close) {
            ListUtils.pop(stack);
        } else {
            MdAstParent node = Objects.equals(token.type, "mdxJsxTextTag") ? new MdxJsxTextElement(tag.name, tag.attributes) : new MdxJsxFlowElement(tag.name, tag.attributes);
            context.enter(node, token, MdxMdastExtension::onErrorRightIsTag);
        }
        if (tag.selfClosing || tag.close) {
            context.exit(token, MdxMdastExtension::onErrorLeftIsTag);
        } else {
            stack.add(tag);
        }
    }

    private static void onErrorRightIsTag(MdastContext context, @Nullable Token closing, Token open) {
        Tag tag = MdxMdastExtension.getTag(context);
        String place = closing != null ? " before the end of `" + closing.type + "`" : "";
        MdAstPosition position = null;
        if (closing != null) {
            position = new MdAstPosition(closing.start, closing.end);
        }
        throw new ParseException("Expected a closing tag for `" + MdxMdastExtension.serializeAbbreviatedTag(tag) + "` (" + MdAstPosition.stringify(open.start, open.end) + ")" + place, position, "mdast-util-mdx-jsx:end-tag-mismatch");
    }

    private static void onErrorLeftIsTag(MdastContext context, @Nullable Token a, Token b) {
        Tag tag = MdxMdastExtension.getTag(context);
        throw new ParseException("Expected the closing tag `" + MdxMdastExtension.serializeAbbreviatedTag(tag) + "` either after the end of `" + b.type + "` (" + MdAstPosition.stringify(b.end) + ") or another opening tag after the start of `" + b.type + "` (" + MdAstPosition.stringify(b.start) + ")", a != null ? a.start : null, a != null ? a.end : null, "mdast-util-mdx-jsx:end-tag-mismatch");
    }

    private static String serializeAbbreviatedTag(Tag tag) {
        return "<" + (Serializable)(tag.close ? Character.valueOf('/') : "") + Objects.requireNonNullElse(tag.name, "") + ">";
    }

    private static List<Tag> getStack(MdastContext context) {
        return Objects.requireNonNull(context.get(TAG_STACK), "stack is missing from context");
    }

    private static Tag getTag(MdastContext context) {
        return Objects.requireNonNull(context.get(TAG), "tag is missing from context");
    }

    private static class Tag {
        @Nullable
        String name;
        List<MdxJsxAttributeNode> attributes = new ArrayList<MdxJsxAttributeNode>();
        boolean close;
        boolean selfClosing;
        Point start;
        Point end;

        public Tag(Token token) {
            this.start = token.start;
            this.end = token.end;
        }

        public MdAstPosition position() {
            return new MdAstPosition(this.start, this.end);
        }
    }
}

