/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.redstone_wire;

import me.jellysquid.mods.lithium.common.util.DirectionConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RedStoneWireBlock.class})
public class RedstoneWireBlockMixin
extends Block {
    private static final int MIN = 0;
    private static final int MAX = 15;
    private static final int MAX_WIRE = 14;

    public RedstoneWireBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"getReceivedRedstonePower"}, cancellable=true, at={@At(value="HEAD")})
    private void getReceivedPowerFaster(Level world, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.getReceivedPower(world, pos));
    }

    private int getReceivedPower(Level world, BlockPos pos) {
        LevelChunk chunk = world.m_46745_(pos);
        int power = 0;
        for (Direction dir : DirectionConstants.VERTICAL) {
            BlockPos side = pos.m_121945_(dir);
            BlockState neighbor = chunk.m_8055_(side);
            if (neighbor.m_60795_() || neighbor.m_60713_((Block)this) || (power = Math.max(power, this.getPowerFromVertical(world, side, neighbor, dir))) < 15) continue;
            return 15;
        }
        BlockPos up = pos.m_7494_();
        boolean checkWiresAbove = !chunk.m_8055_(up).m_60796_((BlockGetter)world, up);
        for (Direction dir : DirectionConstants.HORIZONTAL) {
            if ((power = Math.max(power, this.getPowerFromSide(world, pos.m_121945_(dir), dir, checkWiresAbove))) < 15) continue;
            return 15;
        }
        return power;
    }

    private int getPowerFromVertical(Level world, BlockPos pos, BlockState state, Direction toDir) {
        int power = state.m_60746_((BlockGetter)world, pos, toDir);
        if (power >= 15) {
            return 15;
        }
        if (state.m_60796_((BlockGetter)world, pos)) {
            return Math.max(power, this.getStrongPowerTo(world, pos, toDir.m_122424_()));
        }
        return power;
    }

    private int getPowerFromSide(Level world, BlockPos pos, Direction toDir, boolean checkWiresAbove) {
        BlockPos down;
        BlockState belowState;
        LevelChunk chunk = world.m_46745_(pos);
        BlockState state = chunk.m_8055_(pos);
        if (state.m_60713_((Block)this)) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_61426_) - 1;
        }
        int power = state.m_60746_((BlockGetter)world, pos, toDir);
        if (power >= 15) {
            return 15;
        }
        if (state.m_60796_((BlockGetter)world, pos)) {
            BlockPos up;
            BlockState aboveState;
            if ((power = Math.max(power, this.getStrongPowerTo(world, pos, toDir.m_122424_()))) >= 15) {
                return 15;
            }
            if (checkWiresAbove && power < 14 && (aboveState = chunk.m_8055_(up = pos.m_7494_())).m_60713_((Block)this)) {
                power = Math.max(power, (Integer)aboveState.m_61143_((Property)BlockStateProperties.f_61426_) - 1);
            }
        } else if (power < 14 && (belowState = chunk.m_8055_(down = pos.m_7495_())).m_60713_((Block)this)) {
            power = Math.max(power, (Integer)belowState.m_61143_((Property)BlockStateProperties.f_61426_) - 1);
        }
        return power;
    }

    private int getStrongPowerTo(Level world, BlockPos pos, Direction ignore) {
        int power = 0;
        for (Direction dir : DirectionConstants.ALL) {
            BlockPos side;
            BlockState neighbor;
            if (dir == ignore || (neighbor = world.m_8055_(side = pos.m_121945_(dir))).m_60795_() || neighbor.m_60713_((Block)this) || (power = Math.max(power, neighbor.m_60775_((BlockGetter)world, side, dir))) < 15) continue;
            return 15;
        }
        return power;
    }
}

