/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.new_shield_variants.core.world.item;

import forge.com.cursee.new_shield_variants.core.world.entity.projectile.ThrownFireChargeFabric;
import forge.com.cursee.new_shield_variants.core.world.entity.projectile.ThrownTNTFabric;
import forge.com.cursee.new_shield_variants.core.world.item.NSVShieldItem;
import forge.com.cursee.new_shield_variants.core.world.item.ShieldVariant;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class NSVUseInteractions {
    public static void handle(NSVShieldItem shield, ShieldVariant variant, Level level, Player player, ItemStack itemstack, InteractionHand hand) {
        switch (variant) {
            case BLAZE: {
                NSVUseInteractions.blazeShield(shield, player);
                break;
            }
            case DRAGON_HEAD: {
                NSVUseInteractions.dragonHeadShield(shield, player);
                break;
            }
            case FIRE_CHARGE: {
                NSVUseInteractions.fireChargeShield(shield, level, player, hand);
                break;
            }
            case TNT: {
                NSVUseInteractions.tntShield(shield, level, player, hand);
            }
        }
    }

    private static void blazeShield(NSVShieldItem shield, Player player) {
        List list = player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82377_(4.0, 2.0, 4.0));
        AtomicBoolean ignited = new AtomicBoolean(false);
        list.forEach(entity -> {
            Player other;
            boolean ignites = false;
            if (entity instanceof Monster) {
                ignites = true;
            } else if (entity == player.m_21188_()) {
                ignites = true;
            } else if (entity.m_21214_() == player) {
                ignites = true;
            } else if (entity.m_6779_((LivingEntity)player)) {
                ignites = true;
            } else if (entity.m_5789_() && entity instanceof Player && (other = (Player)entity).m_5647_() != player.m_5647_()) {
                ignites = true;
            }
            if (entity == player) {
                ignites = false;
            }
            if (ignites) {
                if (!entity.m_6060_()) {
                    entity.m_20254_(2);
                }
                ignited.set(true);
            }
        });
        if (ignited.get()) {
            player.m_36335_().m_41524_((Item)shield, 100);
        }
    }

    private static void dragonHeadShield(NSVShieldItem shield, Player player) {
        List list = player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82377_(4.0, 2.0, 4.0));
        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(player.m_9236_(), player.f_19790_, player.f_19791_, player.f_19792_);
        areaeffectcloud.m_19718_((LivingEntity)player);
        areaeffectcloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
        areaeffectcloud.m_19712_(3.0f);
        areaeffectcloud.m_19734_(100);
        areaeffectcloud.m_19738_((7.0f - areaeffectcloud.m_19743_()) / (float)areaeffectcloud.m_19748_());
        areaeffectcloud.m_19716_(new MobEffectInstance(MobEffects.f_19597_, 100, 5));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 50, 2));
        LivingEntity lastHurtBy = player.m_21188_();
        if (!list.isEmpty() || lastHurtBy != null) {
            if (lastHurtBy != null) {
                areaeffectcloud.m_6034_(lastHurtBy.m_20185_(), lastHurtBy.m_20186_(), lastHurtBy.m_20189_());
            } else {
                for (LivingEntity livingentity : list) {
                    double d0 = player.m_20280_((Entity)livingentity);
                    if (!(d0 < 16.0)) continue;
                    areaeffectcloud.m_6034_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                    break;
                }
            }
        }
        player.m_9236_().m_46796_(2006, player.m_20183_(), player.m_20067_() ? -1 : 1);
        player.m_9236_().m_7967_((Entity)areaeffectcloud);
        player.m_36335_().m_41524_((Item)shield, 100);
    }

    private static void fireChargeShield(NSVShieldItem shield, Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!level.f_46443_) {
            ThrownFireChargeFabric throwntnt = new ThrownFireChargeFabric(level, (LivingEntity)player);
            throwntnt.m_37446_(Items.f_42613_.m_7968_());
            throwntnt.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            level.m_7967_((Entity)throwntnt);
        }
        itemstack.m_41721_(itemstack.m_41773_() - 20);
        player.m_36335_().m_41524_((Item)shield, 20);
    }

    private static void tntShield(NSVShieldItem shield, Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!level.f_46443_) {
            ThrownTNTFabric throwntnt = new ThrownTNTFabric(level, (LivingEntity)player);
            throwntnt.m_37446_(Items.f_41996_.m_7968_());
            throwntnt.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            level.m_7967_((Entity)throwntnt);
        }
        itemstack.m_41721_(itemstack.m_41773_() - 20);
        player.m_36335_().m_41524_((Item)shield, 60);
    }
}

