/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.foundation.recipe.requirements;

import com.google.gson.JsonObject;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirementType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MinHeightRequirement
extends RecipeRequirement {
    public static final RecipeRequirementType<?> TYPE = new MinHeightRequirementType();
    public static final MinHeightRequirement EMPTY = new MinHeightRequirement();
    private Integer value;

    public MinHeightRequirement() {
    }

    public MinHeightRequirement(int pValue) {
        this.value = pValue;
    }

    public static MinHeightRequirement of(int pValue) {
        return new MinHeightRequirement(pValue);
    }

    @Override
    public boolean test(Level pLevel, BlockEntity pBlockEntity) {
        if (this.value == null) {
            return true;
        }
        BlockPos pos = pBlockEntity.m_58899_();
        return pos.m_252807_().f_82480_ >= (double)this.value.intValue();
    }

    @Override
    public boolean isPresent() {
        return this.value != null;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public RecipeRequirementType<?> getType() {
        return TYPE;
    }

    private static class MinHeightRequirementType
    extends RecipeRequirementType<MinHeightRequirement> {
        public MinHeightRequirementType() {
            super("min_height");
        }

        @Override
        public MinHeightRequirement fromJson(JsonObject pJson) {
            if (GsonHelper.m_13900_((JsonObject)pJson, (String)this.getId())) {
                return MinHeightRequirement.of(pJson.get(this.getId()).getAsInt());
            }
            return EMPTY;
        }

        @Override
        public JsonObject toJson(JsonObject pJson, RecipeRequirement pRecipeRequirement) {
            if (!pRecipeRequirement.isPresent()) {
                return pJson;
            }
            pJson.addProperty(this.getId(), pRecipeRequirement.toString());
            return pJson;
        }

        @Override
        public MinHeightRequirement fromNetwork(FriendlyByteBuf buffer) {
            boolean hasRequirement = buffer.readBoolean();
            if (hasRequirement) {
                return MinHeightRequirement.of(buffer.readInt());
            }
            return EMPTY;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer, RecipeRequirement pRecipeRequirement) {
            if (pRecipeRequirement == null) {
                pRecipeRequirement = new MinHeightRequirement();
            }
            if (pRecipeRequirement instanceof MinHeightRequirement) {
                buffer.writeBoolean(pRecipeRequirement.isPresent());
                if (pRecipeRequirement.isPresent()) {
                    buffer.writeInt(((MinHeightRequirement)pRecipeRequirement).getValue());
                }
            }
        }
    }
}

