/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.tconstruct;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.entity.ai.workers.crafting.EntityAIWorkBlacksmith;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import steve_gall.minecolonies_compatibility.api.common.repair.CustomizedRepair;
import steve_gall.minecolonies_compatibility.api.common.repair.EntityContext;
import steve_gall.minecolonies_compatibility.api.common.repair.RepairTransaction;
import steve_gall.minecolonies_compatibility.core.common.colony.CitizenHelper;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;
import steve_gall.minecolonies_compatibility.module.common.tconstruct.BrokenItem;
import steve_gall.minecolonies_compatibility.module.common.tconstruct.MaterialHelper;
import steve_gall.minecolonies_compatibility.module.common.tconstruct.RepairKit;
import steve_gall.minecolonies_compatibility.module.common.tconstruct.TConstructToolHelper;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableDeliverable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class TConstructRepair
extends CustomizedRepair {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return new ResourceLocation(ModuleManager.TCONSTRUCT.getModId(), "repair_kit");
    }

    @Override
    @Nullable
    public CustomizedRepair.CheckResult check(@NotNull EntityContext context) {
        boolean hasTool;
        EntityAIWorkBlacksmith ai = context.getAI();
        AbstractEntityCitizen worker = context.getWorker();
        InventoryCitizen inventory = worker.getInventoryCitizen();
        ICitizenData citizenData = worker.getCitizenData();
        RegistryAccess registryAccess = worker.m_9236_().m_9598_();
        HashMap<String, MaterialVariantId> variantIds = new HashMap<String, MaterialVariantId>();
        Object2IntOpenHashMap toolSlots = new Object2IntOpenHashMap();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            if (!TConstructToolHelper.isToolAndBroken(item)) continue;
            ToolStack toolStack = ToolStack.from((ItemStack)item);
            for (MaterialVariantId variantId : TConstructToolHelper.getRepairVariantIds((IToolStackView)toolStack)) {
                variantIds.put(variantId.toString(), variantId);
                toolSlots.put((Object)variantId.toString(), i);
            }
        }
        for (Object key : variantIds.keySet()) {
            MaterialVariantId materialVariantId = (MaterialVariantId)variantIds.get(key);
            int toolSlot = toolSlots.getInt(key);
            Predicate<ItemStack> kitPredicate = stack -> RepairKit.isRepairKitItem(stack, variantId);
            int kitSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)inventory, kitPredicate);
            ItemStack tool = inventory.getStackInSlot(toolSlot);
            int kitCount = TConstructToolHelper.getRepairCount(tool, materialVariantId, registryAccess);
            if (kitSlot > -1) {
                return CustomizedRepair.CheckResult.repair(new Transaction(materialVariantId, toolSlot, kitSlot));
            }
            if (InventoryUtils.hasItemInProvider((ICapabilityProvider)ai.building, kitPredicate)) {
                return CustomizedRepair.CheckResult.needsCurrently((Tuple<Predicate<ItemStack>, Integer>)new Tuple(kitPredicate, (Object)kitCount));
            }
            if (CitizenHelper.isRequested(citizenData, CustomizableDeliverable.TYPE_TOKEN, r -> {
                RepairKit kit;
                IDeliverableObject patt3068$temp = ((CustomizableDeliverable)r.getRequest()).getObject();
                return patt3068$temp instanceof RepairKit && (kit = (RepairKit)patt3068$temp).getVariantId().matchesVariant(variantId);
            })) continue;
            citizenData.createRequestAsync((IRequestable)new CustomizableDeliverable((IDeliverableObject)new RepairKit(materialVariantId, kitCount)));
        }
        boolean any = false;
        for (IRequest iRequest : CitizenHelper.getRequests(citizenData, CustomizableDeliverable.TYPE_TOKEN, r -> ((CustomizableDeliverable)r.getRequest()).getObject() instanceof BrokenItem)) {
            if (((BrokenItem)((CustomizableDeliverable)iRequest.getRequest()).getObject()).getAI() == null) {
                citizenData.getColony().getRequestManager().updateRequestState(iRequest.getId(), RequestState.CANCELLED);
                continue;
            }
            any = true;
        }
        if (!any) {
            citizenData.createRequestAsync((IRequestable)new CustomizableDeliverable((IDeliverableObject)new BrokenItem(ai)));
        }
        if (hasTool = InventoryUtils.hasItemInProvider((ICapabilityProvider)ai.building, TConstructToolHelper::isToolAndBroken)) {
            return CustomizedRepair.CheckResult.needsCurrently((Tuple<Predicate<ItemStack>, Integer>)new Tuple(TConstructToolHelper::isToolAndBroken, (Object)1));
        }
        return null;
    }

    public class Transaction
    extends RepairTransaction {
        private final MaterialVariantId variantId;
        private final int brokenItemSlot;
        private final int kitSlot;

        public Transaction(MaterialVariantId variantId, int brokenItemSlot, int kitSlot) {
            this.variantId = variantId;
            this.brokenItemSlot = brokenItemSlot;
            this.kitSlot = kitSlot;
        }

        @Override
        public boolean onHitting(@NotNull EntityContext context) {
            InventoryCitizen inventory = context.getWorker().getInventoryCitizen();
            ItemStack brokenItem = inventory.getStackInSlot(this.brokenItemSlot);
            if (!TConstructToolHelper.canRepair(brokenItem)) {
                return false;
            }
            ToolStack tool = ToolStack.from((ItemStack)brokenItem);
            List<MaterialVariantId> variantIds = TConstructToolHelper.getRepairVariantIds((IToolStackView)tool);
            if (!MaterialHelper.anyMatchesVariantId(variantIds, this.variantId)) {
                return false;
            }
            ItemStack repairKit = inventory.getStackInSlot(this.kitSlot);
            if (!RepairKit.isRepairKitItem(repairKit, this.variantId)) {
                return false;
            }
            context.setHands(this.kitSlot, this.brokenItemSlot);
            return true;
        }

        @Override
        @NotNull
        public RepairTransaction.RepairResult onHitComplete(@NotNull EntityContext context) {
            InventoryCitizen inventory = context.getWorker().getInventoryCitizen();
            ItemStack brokenItem = inventory.getStackInSlot(this.brokenItemSlot);
            ItemStack repairKit = inventory.getStackInSlot(this.kitSlot);
            ItemStack repaired = TConstructToolHelper.repair(brokenItem, repairKit, context.getWorker().m_9236_().m_9598_());
            inventory.setStackInSlot(this.brokenItemSlot, repaired);
            repairKit.m_41774_(1);
            Predicate<ItemStack> kitPredicate = stack -> RepairKit.isRepairKitItem(stack, this.variantId);
            int newKitSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)inventory, kitPredicate);
            if (newKitSlot == -1 || !TConstructToolHelper.canRepair(repaired)) {
                return RepairTransaction.RepairResult.completed();
            }
            return RepairTransaction.RepairResult.next(new Transaction(this.variantId, this.brokenItemSlot, newKitSlot));
        }
    }
}

