/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_vinery;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.block.CherryLeavesBlock;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class CherryLeavesFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return ObjectRegistry.DARK_CHERRY_LEAVES.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)ObjectRegistry.DARK_CHERRY_SAPLING.get()), new ItemStack((ItemLike)ObjectRegistry.DARK_CHERRY_LEAVES.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)ObjectRegistry.CHERRY.get()), new ItemStack((ItemLike)ObjectRegistry.ROTTEN_CHERRY.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == ObjectRegistry.DARK_CHERRY_LEAVES.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        return (Boolean)state.m_61143_((Property)CherryLeavesBlock.VARIANT) != false && (Boolean)state.m_61143_((Property)CherryLeavesBlock.HAS_CHERRIES) != false;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            RandomSource random = level.m_213780_();
            int dropCount = random.m_188499_() ? Mth.m_216271_((RandomSource)random, (int)1, (int)3) : 1;
            boolean rotten = random.m_188503_(8) == 0;
            ItemStack dropStack = new ItemStack(rotten ? (ItemLike)ObjectRegistry.ROTTEN_CHERRY.get() : (ItemLike)ObjectRegistry.CHERRY.get(), dropCount);
            BlockState newState = (BlockState)context.getState().m_61124_((Property)CherryLeavesBlock.HAS_CHERRIES, (Comparable)Boolean.valueOf(false));
            level.m_46597_(context.getPosition(), newState);
            return Collections.singletonList(dropStack);
        }
        return Collections.emptyList();
    }
}

