/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_brewery;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.brewery.block.HopsCropBlock;
import net.satisfy.brewery.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantSeedContext;

public class HopsCrop
extends CustomizedCrop {
    public static final int MAX_AGE = 3;

    @Override
    public boolean isSeed(@NotNull PlantSeedContext context) {
        return context.getSeed().m_41720_() == ObjectRegistry.HOPS_SEEDS.get();
    }

    @Override
    public boolean isCrop(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() instanceof HopsCropBlock;
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestPositionFunction getSpecialHarvestPosition(@NotNull PlantBlockContext context) {
        return this::getHarvestPosition;
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestMethodFunction getSpecialHarvestMethod(@NotNull PlantBlockContext context) {
        return this::harvest;
    }

    @Nullable
    private BlockPos getHarvestPosition(@NotNull PlantBlockContext context) {
        BlockState state;
        BlockPos pos = context.getPosition();
        while ((state = context.getLevel().m_8055_(pos)).m_60734_() instanceof HopsCropBlock) {
            if ((Integer)state.m_61143_((Property)HopsCropBlock.AGE) >= 3) {
                return pos;
            }
            pos = pos.m_7494_();
        }
        return null;
    }

    @NotNull
    private List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader;
        BlockPos pos = this.getHarvestPosition(context);
        if (pos != null && (levelReader = context.getLevel()) instanceof LevelAccessor) {
            LevelAccessor level = (LevelAccessor)levelReader;
            BlockState state = level.m_8055_(pos);
            int amount = level.m_213780_().m_188503_(2) + 1;
            ItemStack drop = new ItemStack((ItemLike)ObjectRegistry.HOPS.get(), amount);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)HopsCropBlock.AGE, (Comparable)Integer.valueOf(1)), 2);
            return Collections.singletonList(drop);
        }
        return Collections.emptyList();
    }
}

