/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.crafting.GenericRecipeHelper;
import steve_gall.minecolonies_compatibility.core.common.crafting.IngredientHelper;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class CookingGenericRecipe
implements IGenericRecipe {
    private final ResourceLocation recipeId;
    private final List<List<ItemStack>> input;
    private final List<ItemStack> container;
    private final ItemStack output;
    private final List<ItemStack> additionalOutputs;

    public CookingGenericRecipe(CookingPotRecipe recipe, RegistryAccess registryAccess) {
        this(recipe.m_6423_(), IngredientHelper.getStacksList((List<Ingredient>)recipe.m_7527_()), Collections.singletonList(recipe.getOutputContainer()), recipe.m_8043_(registryAccess));
    }

    public CookingGenericRecipe(ResourceLocation recipeId, List<List<ItemStack>> ingredients, List<ItemStack> container, ItemStack output) {
        this.recipeId = recipeId;
        this.input = new ArrayList<List<ItemStack>>(ingredients);
        this.container = new ArrayList<ItemStack>();
        if (!container.isEmpty() && !container.stream().allMatch(ItemStack::m_41619_)) {
            this.container.addAll(container);
        }
        this.output = output;
        this.additionalOutputs = GenericRecipeHelper.getAdditionalOutputs(ingredients, CookingGenericRecipe::getCraftingRemainingStack);
    }

    public int getGridSize() {
        return 1;
    }

    @Nullable
    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.output;
    }

    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return Collections.singletonList(this.output);
    }

    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return this.additionalOutputs;
    }

    public static ItemStack getCraftingRemainingStack(ItemStack stack) {
        if (stack.hasCraftingRemainingItem()) {
            return stack.getCraftingRemainingItem();
        }
        if (CookingPotBlockEntity.INGREDIENT_REMAINDER_OVERRIDES.containsKey(stack.m_41720_())) {
            return ((Item)CookingPotBlockEntity.INGREDIENT_REMAINDER_OVERRIDES.get(stack.m_41720_())).m_7968_();
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public List<List<ItemStack>> getInputs() {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        list.addAll(this.input);
        if (this.container.size() > 0) {
            list.add(this.container);
        }
        return list;
    }

    public Optional<Boolean> matchesOutput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    public Optional<Boolean> matchesInput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    @NotNull
    public Block getIntermediate() {
        return (Block)ModBlocks.COOKING_POT.get();
    }

    @Nullable
    public ResourceLocation getLootTable() {
        return null;
    }

    @NotNull
    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    @Nullable
    public EntityType<?> getRequiredEntity() {
        return null;
    }

    @NotNull
    public Supplier<List<Component>> getRestrictions() {
        return Collections::emptyList;
    }

    public int getLevelSort() {
        return -1;
    }
}

