/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight;

import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import steve_gall.minecolonies_compatibility.api.common.event.AnimalHerdingLootEvent;
import steve_gall.minecolonies_compatibility.api.common.event.AnimalHerdingToolEvent;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;
import steve_gall.minecolonies_compatibility.module.client.farmersdelight.CookingTeachScreen;
import steve_gall.minecolonies_compatibility.module.client.farmersdelight.CuttingTeachScreen;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.MushroomColonyFruit;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.RiceFruit;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.TomatoCrop;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CookingRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleBuildingModules;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleCraftingTypes;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleJobs;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleMenuTypes;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.network.CookingOpenTeachMessage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.network.CuttingOpenTeachMessage;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizedRecipeStorageRegistry;
import steve_gall.minecolonies_tweaks.api.common.network.NetworkChannel;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.registry.ModItems;

public class FarmersDelightModule
extends AbstractModule {
    @Override
    protected void onLoad() {
        super.onLoad();
        IEventBus fml_bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModuleCraftingTypes.REGISTER.register(fml_bus);
        ModuleMenuTypes.REGISTER.register(fml_bus);
        ModuleJobs.REGISTER.register(fml_bus);
        IEventBus forge_bus = MinecraftForge.EVENT_BUS;
        forge_bus.addListener(this::onAnimalHerdingTool);
        forge_bus.addListener(this::onAnimalHerdingLoot);
        NetworkChannel network = MineColoniesCompatibility.network();
        network.registerMessage(CuttingOpenTeachMessage.class, CuttingOpenTeachMessage::new);
        network.registerMessage(CookingOpenTeachMessage.class, CookingOpenTeachMessage::new);
        CustomizedRecipeStorageRegistry.INSTANCE.register(CuttingRecipeStorage.ID, CuttingRecipeStorage::serialize, CuttingRecipeStorage::deserialize);
        CustomizedRecipeStorageRegistry.INSTANCE.register(CookingRecipeStorage.ID, CookingRecipeStorage::serialize, CookingRecipeStorage::deserialize);
    }

    @Override
    protected void onFMLCommonSetup(FMLCommonSetupEvent e) {
        super.onFMLCommonSetup(e);
        e.enqueueWork(() -> {
            CustomizedCrop.register(new TomatoCrop());
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                if (!(block instanceof MushroomColonyBlock)) continue;
                MushroomColonyBlock mushroomColony = (MushroomColonyBlock)block;
                CustomizedFruit.register(new MushroomColonyFruit(mushroomColony));
            }
            CustomizedFruit.register(new RiceFruit());
            ((BuildingEntry)ModBuildings.kitchen.get()).getModuleProducers().add(ModuleBuildingModules.CHEF_CUTTING);
            ((BuildingEntry)ModBuildings.kitchen.get()).getModuleProducers().add(ModuleBuildingModules.CHEF_COOKING);
            ((BuildingEntry)ModBuildings.lumberjack.get()).getModuleProducers().add(ModuleBuildingModules.LUMBERJACK_CUTTING);
            ((BuildingEntry)ModBuildings.stoneMason.get()).getModuleProducers().add(ModuleBuildingModules.STONEMASON_CUTTING);
        });
    }

    @Override
    protected void onFMLClientSetup(FMLClientSetupEvent e) {
        super.onFMLClientSetup(e);
        MenuScreens.m_96206_((MenuType)((MenuType)ModuleMenuTypes.CUTTING_TEACH.get()), CuttingTeachScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModuleMenuTypes.COOKING_TEACH.get()), CookingTeachScreen::new);
    }

    private void onAnimalHerdingTool(AnimalHerdingToolEvent e) {
        EntityType type = e.getAnimal().m_6095_();
        if (type == EntityType.f_20510_ || type == EntityType.f_20456_) {
            e.register(ModToolTypes.KNIFE.getToolType());
        }
    }

    private void onAnimalHerdingLoot(AnimalHerdingLootEvent e) {
        EntityType<?> type = e.getRecipe().getRequiredEntity();
        if ((type == EntityType.f_20510_ || type == EntityType.f_20456_) && e.getRecipe().getRequiredTool() == ModToolTypes.KNIFE.getToolType()) {
            e.register(new LootTableAnalyzer.LootDrop(Collections.singletonList(new ItemStack((ItemLike)ModItems.HAM.get())), 0.5f, 1.0f, false));
        }
    }

    public static List<Component> getChanceTooltip(float chance) {
        if (chance != 1.0f) {
            return Collections.singletonList(FarmersDelightModule.createChanceTooltip(chance));
        }
        return Collections.emptyList();
    }

    public static Component createChanceTooltip(float chance) {
        return Component.m_237110_((String)"farmersdelight.jei.chance", (Object[])new Object[]{(double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))}).m_130940_(ChatFormatting.GOLD);
    }
}

