/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.butchercraft.menu;

import com.lance5057.butchercraft.ButchercraftRecipes;
import com.lance5057.butchercraft.workstations.grinder.GrinderContainer;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.crafting.GrinderGenericRecipe;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.init.ModuleMenuTypes;

public class GrinderTeachMenu
extends TeachRecipeMenu<GrinderRecipe> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int INGREDIENT_X = 26;
    public static final int INGREDIENT_Y = 35;
    public static final int ATTACHMENT_X = 44;
    public static final int ATTACHMENT_Y = 35;
    public static final int CASING_X = 62;
    public static final int CASING_Y = 35;
    public static final int RESULT_X = 116;
    public static final int RESULT_Y = 35;

    public GrinderTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModuleMenuTypes.GRINDER_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public GrinderTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.GRINDER_TEACH.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 3);
        this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, 0, 26, 35)));
        this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, 1, 44, 35)));
        this.inputSlots.add(this.m_38897_(new TeachInputSlot(this.inputContainer, 2, 62, 35)));
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.m_38897_(new TeachResultSlot(this.resultContainer, 0, 116, 35)));
    }

    @Override
    protected IMenuRecipeValidator<GrinderRecipe> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<GrinderRecipe, GrinderContainer>(this.inventory.f_35978_.m_9236_()){

            @Override
            public RecipeType<GrinderRecipe> getRecipeType() {
                return (RecipeType)ButchercraftRecipes.GRINDER.get();
            }

            @Override
            protected boolean test(GrinderRecipe recipe, Container container, ServerPlayer player) {
                ItemStack ingredient = container.m_8020_(0);
                ItemStack attachment = container.m_8020_(1);
                ItemStack casing = container.m_8020_(2);
                GrinderContainer grinderContainer = new GrinderContainer(ingredient, attachment);
                if (!recipe.matches(grinderContainer, player.m_9236_())) {
                    return false;
                }
                return GrinderGenericRecipe.casing(attachment).test(casing);
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull GrinderRecipe recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(recipe, payload);
        List<ItemStack> input = NBTUtils2.deserializeList(payload, "input", ItemStack::m_41712_);
        this.inputContainer.m_6836_(0, input.get(0));
        this.inputContainer.m_6836_(1, input.get(1));
        this.inputContainer.m_6836_(2, input.get(2));
    }

    @Override
    protected void onRecipeChanged(RegistryAccess registryAccess) {
        this.resultContainer.m_6836_(0, this.recipe != null ? ((GrinderRecipe)this.recipe).m_8043_(registryAccess) : ItemStack.f_41583_);
    }
}

