/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.mojang.authlib.GameProfile;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyHelper {
    @Nullable
    public static FakePlayer getFakeOwner(IColony colony) {
        Level level = colony.getWorld();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            return ColonyHelper.getFakeOwner(colony, level2);
        }
        return null;
    }

    @NotNull
    public static FakePlayer getFakeOwner(IColony colony, ServerLevel level) {
        IPermissions permissions = colony.getPermissions();
        GameProfile ownerProfile = new GameProfile(permissions.getOwner(), permissions.getOwnerName());
        return FakePlayerFactory.get((ServerLevel)level, (GameProfile)ownerProfile);
    }

    private ColonyHelper() {
    }
}

