/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.building.module;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.IModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.entity.pathfinding.WorkingBlocksPathResult;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;

public abstract class AbstractModuleWithExternalWorkingBlocks
extends AbstractBuildingModule
implements IModuleWithExternalWorkingBlocks,
ITickingModule,
IPersistentModule {
    public static final String TAG_REGISTERED_POSITIONS = MineColoniesCompatibility.rl("registered_positions").toString();
    private final Set<BlockPos> workingPositions = new HashSet<BlockPos>();
    private WorkingBlocksPathResult pathReuslt;

    public void deserializeNBT(CompoundTag compound) {
        this.workingPositions.clear();
        this.workingPositions.addAll(BlockPosUtil.readPosListFromNBT((CompoundTag)compound, (String)TAG_REGISTERED_POSITIONS));
    }

    public void serializeNBT(@NotNull CompoundTag compound) {
        BlockPosUtil.writePosListToNBT((CompoundTag)compound, (String)TAG_REGISTERED_POSITIONS, new ArrayList<BlockPos>(this.workingPositions));
    }

    @Override
    public boolean requestFindWorkingBlocks() {
        AbstractEntityCitizen worker = this.getPathFindingCitizen();
        return this.requestFindWorkingBlocks(worker);
    }

    @Override
    public boolean requestFindWorkingBlocks(@Nullable AbstractEntityCitizen citizen) {
        if (this.pathReuslt == null) {
            this.pathReuslt = (WorkingBlocksPathResult)this.createWorkingBlocksFindPath(citizen).getResult();
            this.pathReuslt.startJob(Pathfinding.getExecutor());
            return true;
        }
        if (this.pathReuslt.isDone()) {
            for (BlockPos pos : this.pathReuslt.positions) {
                if (!this.workingPositions.add(pos)) continue;
                this.onWorkingBlockAdded(pos);
            }
            this.pathReuslt = null;
            this.markDirty();
            return false;
        }
        return true;
    }

    public void onColonyTick(@NotNull IColony colony) {
        this.requestFindWorkingBlocks();
    }

    @Nullable
    protected AbstractEntityCitizen getPathFindingCitizen() {
        return null;
    }

    public void onBlockPlacedInBuilding(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level level) {
        this.addWorkingBlock(pos);
    }

    @Override
    public boolean addWorkingBlock(@NotNull BlockPos pos) {
        BlockState state;
        Level level = this.building.getColony().getWorld();
        if (this.isWorkingBlock((LevelReader)level, pos, state = level.m_8055_(pos)) && this.workingPositions.add(pos)) {
            this.onWorkingBlockAdded(pos);
            this.markDirty();
            return true;
        }
        return false;
    }

    protected void onWorkingBlockAdded(@NotNull BlockPos pos) {
    }

    @Override
    public boolean removeWorkingBlock(@Nullable BlockPos pos) {
        if (this.workingPositions.remove(pos)) {
            this.onWorkingBlockRemoved(pos);
            this.markDirty();
            return true;
        }
        return false;
    }

    protected void onWorkingBlockRemoved(@Nullable BlockPos pos) {
    }

    @Override
    public boolean containsWorkingBlock(@Nullable BlockPos pos) {
        return this.workingPositions.contains(pos);
    }

    public List<BlockPos> getRegisteredBlocks() {
        return new ArrayList<BlockPos>(this.workingPositions);
    }
}

