/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.mixin;

import com.leclowndu93150.custom_nether_portals.utils.HashSetQueue;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PortalShape.class})
public abstract class PortalShapeMixin {
    @Unique
    private boolean customShapes$valid = false;
    @Unique
    HashSet<BlockPos> customShapes$validPortalPositions = new HashSet();
    @Unique
    int customShapes$portalBlockCount = 0;
    @Final
    @Shadow
    private LevelAccessor f_77686_;
    @Final
    @Shadow
    private Direction f_77688_;
    @Final
    @Shadow
    private Direction.Axis f_77687_;

    @Inject(method={"isEmpty"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isEmpty(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (state.m_60713_(Blocks.f_50723_)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void constructor(LevelAccessor level, BlockPos startPos, Direction.Axis axis, CallbackInfo ci) {
        this.customShapes$valid = this.customShapes$checkAreaForPortalValidity(startPos, axis);
    }

    @Unique
    private boolean customShapes$checkAreaForPortalValidity(BlockPos startPos, Direction.Axis axis) {
        this.customShapes$validPortalPositions.clear();
        HashSet<BlockPos> validFrameBlocks = new HashSet<BlockPos>();
        HashSetQueue<BlockPos> positionsToCheck = new HashSetQueue<BlockPos>();
        boolean minSizeFound = true;
        List<Direction> directions = List.of(Direction.DOWN, Direction.UP, this.f_77688_.m_122424_(), this.f_77688_);
        positionsToCheck.push(startPos);
        while (!positionsToCheck.isEmpty()) {
            BlockPos pos = (BlockPos)positionsToCheck.pop();
            if (this.customShapes$validPortalPositions.contains(pos) || validFrameBlocks.contains(pos)) continue;
            boolean isOrCanBePortal = this.customShapes$isValidPosForPortalBlock(pos);
            boolean isFrameBlock = this.customShapes$isValidFrameBlock(pos);
            if (!isOrCanBePortal && !isFrameBlock) {
                return false;
            }
            if (isOrCanBePortal) {
                this.customShapes$validPortalPositions.add(pos);
                if (this.customShapes$validPortalPositions.size() > 1000) {
                    return false;
                }
                if (this.f_77686_.m_8055_(pos).m_60713_(Blocks.f_50142_)) {
                    ++this.customShapes$portalBlockCount;
                }
                if (!minSizeFound && (this.customShapes$validPortalPositions.contains(pos.m_7494_()) || this.customShapes$validPortalPositions.contains(pos.m_7495_()))) {
                    minSizeFound = true;
                }
                directions.forEach(direction -> {
                    BlockPos neighborPos = pos.m_121945_(direction);
                    if (!this.customShapes$validPortalPositions.contains(neighborPos) && !validFrameBlocks.contains(neighborPos)) {
                        positionsToCheck.push(neighborPos);
                    }
                });
                continue;
            }
            validFrameBlocks.add(pos);
        }
        return minSizeFound;
    }

    @Unique
    private boolean customShapes$isValidPosForPortalBlock(BlockPos pos) {
        BlockState state = this.f_77686_.m_8055_(pos);
        return (state.m_60795_() || state.m_60713_(Blocks.f_50083_) || state.m_60713_(Blocks.f_50142_) || state.m_60713_(Blocks.f_50723_)) && !this.f_77686_.m_151570_(pos);
    }

    @Unique
    private boolean customShapes$isValidFrameBlock(BlockPos pos) {
        BlockState state = this.f_77686_.m_8055_(pos);
        return (state.m_60713_(Blocks.f_50080_) || state.m_60713_(Blocks.f_50723_)) && !this.f_77686_.m_151570_(pos);
    }

    @Inject(method={"createPortalBlocks"}, at={@At(value="HEAD")}, cancellable=true)
    private void createPortal(CallbackInfo ci) {
        BlockState blockState = (BlockState)Blocks.f_50142_.m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)this.f_77687_);
        this.customShapes$validPortalPositions.forEach(pos -> this.f_77686_.m_7731_(pos, blockState, 18));
        ci.cancel();
    }

    @Inject(method={"isValid"}, at={@At(value="HEAD")}, cancellable=true)
    private void isValid(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)this.customShapes$valid);
    }

    @Inject(method={"isComplete"}, at={@At(value="HEAD")}, cancellable=true)
    private void isComplete(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(this.customShapes$valid && this.customShapes$validPortalPositions.size() == this.customShapes$portalBlockCount ? 1 : 0));
    }
}

