/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.block;

import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HorizontalNetherPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public HorizontalNetherPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    private void breakConnectedPortalBlocks(Level level, BlockPos startPos, Direction.Axis axis) {
        HashSet<BlockPos> toBreak = new HashSet<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighbor = startPos.m_121945_(direction);
            queue.add(neighbor);
        }
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            if (visited.contains(pos)) continue;
            visited.add(pos);
            BlockState state = level.m_8055_(pos);
            if (!(state.m_60734_() instanceof HorizontalNetherPortalBlock) || state.m_61143_(AXIS) != axis || pos.m_123342_() != startPos.m_123342_()) continue;
            toBreak.add(pos);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos neighbor = pos.m_121945_(direction);
                if (visited.contains(neighbor)) continue;
                queue.add(neighbor);
            }
        }
        for (BlockPos pos : toBreak) {
            level.m_46961_(pos, false);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !level.m_5776_()) {
            this.breakConnectedPortalBlocks(level, pos, (Direction.Axis)state.m_61143_(AXIS));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.m_122434_();
        Direction.Axis direction$axis1 = (Direction.Axis)state.m_61143_(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.m_122479_();
        return !flag && !facingState.m_60713_((Block)this) && !new PortalShape(level, currentPos, direction$axis1).m_77744_() ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(100) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() + random.m_188500_();
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            double d3 = ((double)random.m_188501_() - 0.5) * 0.5;
            double d4 = ((double)random.m_188501_() - 0.5) * 0.5;
            double d5 = ((double)random.m_188501_() - 0.5) * 0.5;
            int j = random.m_188503_(2) * 2 - 1;
            Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
            if (axis == Direction.Axis.X) {
                if (!level.m_8055_(pos.m_122012_()).m_60713_((Block)this) && !level.m_8055_(pos.m_122019_()).m_60713_((Block)this)) {
                    d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                    d5 = random.m_188501_() * 2.0f * (float)j;
                } else {
                    d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                    d3 = random.m_188501_() * 2.0f * (float)j;
                }
            } else if (!level.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !level.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                d3 = random.m_188501_() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                d5 = random.m_188501_() * 2.0f * (float)j;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_6072_()) {
            entity.m_20221_(pos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }
}

