/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.handler;

import cofh.lib.util.Constants;
import cofh.requack.collection.ColUtils;
import cofh.requack.util.SneakyUtils;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.dynamics.ThermalDynamics;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.api.grid.IGridContainer;
import cofh.thermal.dynamics.api.grid.IGridType;
import cofh.thermal.dynamics.api.helper.GridHelper;
import cofh.thermal.dynamics.common.network.packet.client.GridDebugPacket;
import cofh.thermal.dynamics.grid.Grid;
import cofh.thermal.dynamics.grid.GridNode;
import cofh.thermal.dynamics.handler.GraphHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.graph.EndpointPair;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class GridContainer
implements IGridContainer,
INBTSerializable<ListTag> {
    private static final boolean DEBUG = GridContainer.class.desiredAssertionStatus();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<UUID> USED_UUIDS = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<BlockPos, Grid<?, ?>> gridPosLookup = new HashMap();
    private final Map<UUID, Grid<?, ?>> grids = new HashMap();
    private final Map<UUID, Grid<?, ?>> loadedGrids = new HashMap();
    private final Level world;
    private int tickCounter;

    public GridContainer(Level world) {
        this.world = world;
    }

    private static boolean canConnectTo(IDuct<?, ?> from, IDuct<?, ?> to, Direction dir) {
        return from.canConnectTo(to, dir) && to.canConnectTo(from, dir.m_122424_());
    }

    @Override
    public void onDuctPlaced(IDuct<?, ?> duct, @Nullable Direction connectionPreference) {
        this.gridHostPlaced(duct, connectionPreference);
    }

    private <G extends Grid<G, N>, N extends GridNode<G>> void gridHostPlaced(IDuct<G, N> host, @Nullable Direction connectionPreference) {
        this.constructNewGrid(host);
        EnumMap<Direction, IDuct<G, N>> adjacentGrids = this.getAdjacentGrids(host);
        if (adjacentGrids.isEmpty()) {
            return;
        }
        ArrayList dirs = Lists.newArrayList((Object[])Constants.DIRECTIONS);
        if (connectionPreference != null) {
            dirs.remove(connectionPreference);
            dirs.add(0, connectionPreference);
        }
        for (Direction dir : dirs) {
            IDuct<?, ?> other = GridHelper.getGridHost((BlockGetter)this.world, host.getHostPos().m_121945_(dir));
            if (other == null) continue;
            if (!GridContainer.canConnectTo(host, other, dir)) {
                if (host.getConnectionType(dir).allowDuctConnection()) {
                    host.setConnectionType(dir, IDuct.ConnectionType.DISABLED);
                }
                if (!other.getConnectionType(dir.m_122424_()).allowDuctConnection()) continue;
                other.setConnectionType(dir.m_122424_(), IDuct.ConnectionType.DISABLED);
                continue;
            }
            IDuct otherHost = (IDuct)SneakyUtils.unsafeCast(other);
            if (other.getGrid() != host.getGrid()) {
                this.mergeGrids(List.of(otherHost, host));
            }
            Object grid = otherHost.getGrid();
            N otherNode = ((Grid)grid).getNodeOrSplitEdgeAndInsertNode(otherHost.getHostPos());
            N thisNode = ((Grid)grid).getNodeOrSplitEdgeAndInsertNode(host.getHostPos());
            ((Grid)grid).nodeGraph.putEdge(otherNode, thisNode);
            this.simplifyNode(otherNode);
            this.simplifyNode(thisNode);
        }
        ((Grid)host.getGrid()).onModified();
    }

    private <G extends Grid<G, ?>> void constructNewGrid(IDuct<G, ?> host) {
        if (DEBUG) {
            LOGGER.info("Constructing new grid for {}", (Object)host.getHostPos());
        }
        G grid = this.createAndAddGrid(this.nextUUID(), host.getGridType(), true);
        host.setGrid(grid);
        ((Grid)grid).newNode(host.getHostPos());
        this.addGridLookup((Grid<?, ?>)grid, host.getHostPos());
        ((Grid)grid).onGridHostAdded(host);
        ((Grid)grid).onModified();
    }

    private <G extends Grid<G, N>, N extends GridNode<G>> void mergeGrids(List<IDuct<G, N>> branches) {
        HashSet<G> grids = new HashSet<G>();
        for (IDuct<G, N> branch : branches) {
            grids.add(branch.getGrid());
        }
        Grid main = ColUtils.maxBy(grids, e -> e.nodeGraph.nodes().size());
        assert (main != null);
        grids.remove(main);
        for (Grid other : grids) {
            HashSet toBeMoved = new HashSet(other.nodeGraph.nodes());
            main.mergeFrom(other);
            this.replaceGridLookup(main, other, toBeMoved);
            this.grids.remove(other.getId());
            this.loadedGrids.remove(other.getId());
        }
        main.onModified();
    }

    @Override
    public void onDuctRemoved(IDuct<?, ?> duct) {
        this.removeGridHost(duct);
    }

    public <G extends Grid<G, N>, N extends GridNode<G>> void removeGridHost(IDuct<G, N> host) {
        G grid = host.getGrid();
        N removing = host.getNode();
        BlockPos hostPos = host.getHostPos();
        this.removeGridLookup((Grid<?, ?>)grid, host.getHostPos());
        if (removing != null) {
            LinkedList<N> adjacentNodes = new LinkedList<N>();
            ImmutableSet allEdges = ImmutableSet.copyOf((Collection)((Grid)grid).nodeGraph.incidentEdges(removing));
            for (EndpointPair edge : allEdges) {
                GridNode other = edge.nodeU() == removing ? (GridNode)edge.nodeV() : (GridNode)edge.nodeU();
                adjacentNodes.add(((Grid)grid).getNodeOrSplitEdgeAndInsertNode(GridHelper.stepTowards(hostPos, other.getPos())));
            }
            if (DEBUG) {
                LOGGER.info("Removing node: {}", (Object)((GridNode)removing).getPos());
            }
            ((Grid)grid).removeNode(removing);
            for (GridNode adjacentNode : adjacentNodes) {
                this.simplifyNode(adjacentNode);
            }
        } else {
            EndpointPair<N> edge = ((Grid)grid).findEdge(hostPos);
            assert (edge != null) : "Block does not lie on an edge.";
            N a = ((Grid)grid).getNodeOrSplitEdgeAndInsertNode(GridHelper.stepTowards(hostPos, ((GridNode)edge.nodeU()).getPos()));
            N b = ((Grid)grid).getNodeOrSplitEdgeAndInsertNode(GridHelper.stepTowards(hostPos, ((GridNode)edge.nodeV()).getPos()));
            ((Grid)grid).nodeGraph.removeEdge(a, b);
            if (DEBUG) {
                LOGGER.info("Removing edge between: {} and {}", (Object)((GridNode)a).getPos(), (Object)((GridNode)b).getPos());
            }
            this.simplifyNode(a);
            this.simplifyNode(b);
        }
        for (Direction dir : Constants.DIRECTIONS) {
            IDuct<?, ?> adjacent = GridHelper.getGridHost((BlockGetter)host.getHostWorld(), host.getHostPos().m_121945_(dir));
            if (adjacent == null || adjacent.getConnectionType(dir.m_122424_()) != IDuct.ConnectionType.DISABLED) continue;
            adjacent.setConnectionType(dir.m_122424_(), IDuct.ConnectionType.ALLOWED);
        }
        if (!((Grid)grid).getNodes().isEmpty()) {
            ((Grid)grid).onGridHostRemoved(host);
            ((Grid)grid).onModified();
            this.separateGrids(grid);
        } else {
            if (DEBUG) {
                LOGGER.info("Removing grid for {}", (Object)host.getHostPos());
            }
            this.grids.remove(((Grid)grid).getId());
            this.loadedGrids.remove(((Grid)grid).getId());
        }
    }

    @Override
    public boolean onDuctNeighborChanged(IDuct<?, ?> duct) {
        return this.gridNeighborChanged(duct);
    }

    public <G extends Grid<G, N>, N extends GridNode<G>> boolean gridNeighborChanged(IDuct<G, N> duct) {
        G grid = duct.getGrid();
        if (grid == null) {
            return false;
        }
        N node = duct.getNode();
        boolean canExternallyConnect = ((Grid)grid).canConnectExternally(duct.getHostPos());
        if (node != null) {
            if (!canExternallyConnect) {
                this.simplifyNode(node);
            }
            ((GridNode)node).clearConnections();
            return true;
        }
        if (canExternallyConnect) {
            ((Grid)grid).getNodeOrSplitEdgeAndInsertNode(duct.getHostPos());
            return true;
        }
        return false;
    }

    @Override
    public boolean onDuctSideConnected(IDuct<?, ?> duct, Direction side) {
        return this.onSideConnectionChanged(duct, side, false);
    }

    @Override
    public void onDuctSideDisconnecting(IDuct<?, ?> duct, Direction side) {
        this.onSideConnectionChanged(duct, side, true);
    }

    private <G extends Grid<G, N>, N extends GridNode<G>> boolean onSideConnectionChanged(IDuct<G, N> host, Direction changed, boolean disconnect) {
        boolean nodesConnected;
        IDuct<G, N> other = this.getAdjacentGrids(host).get(changed);
        if (other == null) {
            return false;
        }
        G aGrid = host.getGrid();
        G bGrid = other.getGrid();
        boolean connecting = !disconnect;
        boolean bl = nodesConnected = aGrid == bGrid && ((Grid)aGrid).isConnectedTo(host.getHostPos(), other.getHostPos());
        if (connecting == nodesConnected) {
            return true;
        }
        N a = ((Grid)aGrid).getNodeOrSplitEdgeAndInsertNode(host.getHostPos());
        N b = ((Grid)bGrid).getNodeOrSplitEdgeAndInsertNode(other.getHostPos());
        if (connecting) {
            if (DEBUG) {
                LOGGER.info("Connecting nodes due to connectability change. A {}, B {}.", (Object)((GridNode)a).getPos(), (Object)((GridNode)b).getPos());
            }
            if (aGrid != bGrid) {
                this.mergeGrids(Arrays.asList(host, other));
                aGrid = ((GridNode)a).getGrid();
            }
            ((Grid)aGrid).nodeGraph.putEdge(a, b);
            for (GridNode adj : ((Grid)aGrid).nodeGraph.adjacentNodes(a)) {
                if (adj == b || ((Grid)aGrid).nodeGraph.hasEdgeConnecting(a, (Object)adj)) continue;
                this.simplifyNode(adj);
            }
            for (GridNode adj : ((Grid)aGrid).nodeGraph.adjacentNodes(b)) {
                if (adj == a || ((Grid)aGrid).nodeGraph.hasEdgeConnecting(b, (Object)adj)) continue;
                this.simplifyNode(adj);
            }
            this.simplifyNode(a);
            this.simplifyNode(b);
            ((Grid)aGrid).onModified();
        } else {
            if (DEBUG) {
                LOGGER.info("Disconnecting nodes due to connectability change. A {}, B {}.", (Object)((GridNode)a).getPos(), (Object)((GridNode)b).getPos());
            }
            ((Grid)aGrid).nodeGraph.removeEdge(a, b);
            this.simplifyNode(a);
            this.simplifyNode(b);
            if (!this.separateGrids(aGrid)) {
                ((Grid)aGrid).onModified();
            }
        }
        return true;
    }

    private <G extends Grid<G, N>, N extends GridNode<G>> void simplifyNode(N node) {
        G grid = node.getGrid();
        if (!((Grid)grid).nodeGraph.nodes().contains(node)) {
            return;
        }
        if (((Grid)grid).canConnectExternally(node.getPos())) {
            return;
        }
        ArrayList edges = new ArrayList(((Grid)grid).nodeGraph.adjacentNodes(node));
        if (edges.size() != 2) {
            return;
        }
        GridNode a = (GridNode)edges.get(0);
        GridNode b = (GridNode)edges.get(1);
        if (!GridHelper.isOnSameAxis(a.getPos(), b.getPos())) {
            return;
        }
        ((Grid)grid).removeNode(node);
        ((Grid)grid).nodeGraph.putEdge((Object)a, (Object)b);
        if (DEBUG) {
            LOGGER.info("Simplifying grid node '{}' A {}, B {}, Len {}", (Object)node.getPos(), (Object)a.getPos(), (Object)b.getPos(), (Object)GridHelper.numBetween(a.getPos(), b.getPos()));
        }
    }

    private <G extends Grid<G, N>, N extends GridNode<G>> boolean separateGrids(G grid) {
        List splitGraphs = GraphHelper.separateGraphs(grid.nodeGraph);
        if (splitGraphs.size() <= 1) {
            return false;
        }
        if (DEBUG) {
            LOGGER.info("Splitting grid into {} segments.", (Object)splitGraphs.size());
        }
        List<G> newGrids = grid.splitInto(splitGraphs);
        for (Grid newGrid : newGrids) {
            this.replaceGridLookup(newGrid, grid, newGrid.nodeGraph.nodes());
            newGrid.onModified();
        }
        this.grids.remove(grid.getId());
        this.loadedGrids.remove(grid.getId());
        return true;
    }

    public void onWorldTick(TickEvent.Phase phase) {
        if (phase != TickEvent.Phase.END) {
            return;
        }
        try {
            for (Grid<?, ?> grid : this.loadedGrids.values()) {
                grid.tick();
            }
        }
        catch (Exception e) {
            ThermalCore.LOG.error("Thermal Dynamics encountered an error during grid ticking:", (Throwable)e);
        }
        if (DEBUG && this.tickCounter % 10 == 0 && !this.loadedGrids.isEmpty()) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            buffer.m_130130_(this.loadedGrids.size());
            for (Grid<?, ?> grid : this.loadedGrids.values()) {
                grid.debugWriteToPacket(buffer);
            }
            GridDebugPacket gridDebugPacket = new GridDebugPacket(buffer);
            gridDebugPacket.sendToClients();
        }
        ++this.tickCounter;
    }

    public void onChunkLoad(ChunkAccess chunk) {
        for (Grid<?, ?> grid : this.grids.values()) {
            if (!grid.onChunkLoad(chunk)) continue;
            assert (!this.loadedGrids.containsKey(grid.getId()));
            this.loadedGrids.put(grid.getId(), grid);
        }
    }

    public void onChunkUnload(ChunkAccess chunk) {
        HashSet<UUID> rem = new HashSet<UUID>(2);
        for (Grid<?, ?> grid : this.loadedGrids.values()) {
            if (!grid.onChunkUnload(chunk)) continue;
            rem.add(grid.getId());
        }
        this.loadedGrids.keySet().removeAll(rem);
    }

    @Override
    @Nullable
    public Grid<?, ?> getGrid(UUID id) {
        return this.grids.get(id);
    }

    @Override
    @Nullable
    public <G extends Grid<G, ?>> G getGrid(IGridType<G> type, BlockPos pos) {
        Grid<?, ?> grid = this.gridPosLookup.get(pos);
        if (grid == null) {
            return null;
        }
        if (grid.getGridType() != type) {
            throw new IllegalStateException("Grid at position " + pos + " is not of type " + type + ". Got: " + grid.getGridType());
        }
        return (G)((Grid)SneakyUtils.unsafeCast(grid));
    }

    public ListTag serializeNBT() {
        ListTag grids = new ListTag();
        for (Map.Entry<UUID, Grid<?, ?>> entry : this.grids.entrySet()) {
            Grid<?, ?> grid = entry.getValue();
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("id", entry.getKey());
            tag.m_128359_("type", ThermalDynamics.GRID_TYPE_REGISTRY.get().getKey(grid.getGridType()).toString());
            tag.m_128391_(grid.serializeNBT());
            grids.add((Object)tag);
        }
        return grids;
    }

    public void deserializeNBT(ListTag nbt) {
        assert (this.grids.isEmpty());
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag tag = nbt.m_128728_(i);
            UUID id = tag.m_128342_("id");
            assert (!this.grids.containsKey(id)) : "Duplicate grid found.";
            ResourceLocation gridTypeName = new ResourceLocation(tag.m_128461_("type"));
            IGridType gridType = (IGridType)ThermalDynamics.GRID_TYPE_REGISTRY.get().getValue(gridTypeName);
            if (gridType == null) {
                LOGGER.error("Failed to load Grid {} with type {} in world {}. GridType is no longer registered, it will be removed from the world.", (Object)id, (Object)gridTypeName, (Object)this.world.m_46472_().m_135782_());
                continue;
            }
            this.deserializeGrid(tag, id, (IGridType)SneakyUtils.unsafeCast(gridType));
        }
        if (DEBUG) {
            LOGGER.info("Loaded {} grids for {}.", (Object)this.grids.size(), (Object)this.world.m_46472_().m_135782_());
        }
    }

    private <G extends Grid<G, N>, N extends GridNode<G>> void deserializeGrid(CompoundTag tag, UUID id, IGridType<G> gridType) {
        G grid = this.createAndAddGrid(id, gridType, false);
        ((Grid)grid).deserializeNBT(tag);
        for (GridNode node : ((Grid)grid).nodeGraph.nodes()) {
            this.addGridLookup((Grid<?, ?>)grid, node.getPos());
        }
        for (EndpointPair edge : ((Grid)grid).nodeGraph.edges()) {
            this.addGridLookupEdge((Grid<?, ?>)grid, GridHelper.positionsBetween(((GridNode)edge.nodeU()).getPos(), ((GridNode)edge.nodeV()).getPos()));
        }
    }

    private void removeGridLookup(Grid<?, ?> grid, BlockPos node) {
        Grid<?, ?> removed = this.gridPosLookup.remove(node);
        assert (removed == grid);
    }

    private void addGridLookupEdge(Grid<?, ?> grid, Iterable<BlockPos> edge) {
        for (BlockPos pos : edge) {
            this.addGridLookup(grid, pos);
        }
    }

    private void addGridLookup(Grid<?, ?> grid, BlockPos node) {
        Grid<?, ?> added = this.gridPosLookup.put(node, grid);
        assert (added == null);
    }

    private void replaceGridLookupEdge(Grid<?, ?> newGrid, Grid<?, ?> oldGrid, Iterable<BlockPos> edge) {
        for (BlockPos pos : edge) {
            this.replaceGridLookup(newGrid, oldGrid, pos);
        }
    }

    private void replaceGridLookup(Grid<?, ?> newGrid, Grid<?, ?> oldGrid, BlockPos pos) {
        Grid<?, ?> removed = this.gridPosLookup.put(pos, newGrid);
        assert (removed == oldGrid);
    }

    private <G extends Grid<G, N>, N extends GridNode<G>> void replaceGridLookup(G newGrid, G oldGrid, Set<N> nodes) {
        for (GridNode node : nodes) {
            this.replaceGridLookup(newGrid, oldGrid, node.getPos());
        }
        for (EndpointPair edge : newGrid.nodeGraph.edges()) {
            GridNode u = (GridNode)edge.nodeU();
            GridNode v = (GridNode)edge.nodeV();
            boolean containsU = nodes.contains(u);
            boolean containsV = nodes.contains(v);
            assert (containsU == containsV);
            if (!containsU) continue;
            this.replaceGridLookupEdge(newGrid, oldGrid, GridHelper.positionsBetween(u.getPos(), v.getPos()));
        }
    }

    private <G extends Grid<G, N>, N extends GridNode<G>> EnumMap<Direction, IDuct<G, N>> getAdjacentGrids(IDuct<G, N> host) {
        EnumMap<Direction, IDuct<G, N>> adjacentGrids = new EnumMap<Direction, IDuct<G, N>>(Direction.class);
        for (Direction dir : Constants.DIRECTIONS) {
            IDuct<?, ?> other = GridHelper.getGridHost((BlockGetter)this.world, host.getHostPos().m_121945_(dir));
            if (other == null || !GridContainer.canConnectTo(host, other, dir)) continue;
            adjacentGrids.put(dir, (IDuct)SneakyUtils.unsafeCast(other));
        }
        return adjacentGrids;
    }

    public synchronized <G extends Grid<G, ?>> G createAndAddGrid(UUID uuid, IGridType<G> gridType, boolean load) {
        G grid = gridType.createGrid(uuid, this.world);
        this.grids.put(uuid, (Grid<?, ?>)grid);
        if (load) {
            this.loadedGrids.put(uuid, (Grid<?, ?>)grid);
        }
        return grid;
    }

    public UUID nextUUID() {
        UUID uuid;
        while (!USED_UUIDS.add(uuid = UUID.randomUUID()) || this.grids.containsKey(uuid)) {
        }
        return uuid;
    }
}

