/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.sync;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.packet.ControlSyncPacket;
import team.creative.creativecore.common.gui.sync.GuiSyncControl;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;

public class GuiSyncLocalLayer<T extends GuiLayer>
extends GuiSyncControl<GuiLayer, CompoundTag> {
    private final Function<CompoundTag, T> creator;

    GuiSyncLocalLayer(GuiSyncHolder holder, String name, Function<CompoundTag, T> creator) {
        super(holder, name);
        this.creator = creator;
    }

    @Override
    public void receive(GuiLayer layer, CompoundTag tag) {
        layer.getIntegratedParent().openLayer((GuiLayer)this.creator.apply(tag));
    }

    public T open(CompoundTag tag) {
        GuiLayer layer = (GuiLayer)this.creator.apply(tag);
        GuiLayer control = ((GuiSyncHolder.GuiSyncHolderLayer)this.holder).parent;
        IGuiIntegratedParent parent = control.getIntegratedParent();
        parent.openLayer(layer);
        parent.send(new ControlSyncPacket(control, this, (Tag)tag));
        return (T)layer;
    }
}

