/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.misc.BlockAndItem;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.ColorSetModification;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlocksColorInternal
extends SimplePreparableReloadListener<List<JsonElement>> {
    public static final BlocksColorInternal INSTANCE = new BlocksColorInternal();
    public static final List<DyeColor> VANILLA_COLORS = List.of(DyeColor.WHITE, DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.LIGHT_BLUE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.PINK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.BROWN, DyeColor.GREEN, DyeColor.RED, DyeColor.BLACK);
    public static final List<DyeColor> MODDED_COLORS = List.of((DyeColor[])Arrays.stream(DyeColor.values()).filter(v -> !VANILLA_COLORS.contains(v)).toArray(DyeColor[]::new));
    private static final List<String> KNOWN_COLOR_MODS = Stream.of("tinted", "dye_depot", "dyenamics", "delicate_dyes", "mint").filter(PlatHelper::isModLoaded).toList();
    private State defaultState;
    private State state;
    private final Gson gson = new Gson();

    protected List<JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        String directory = "color_sets";
        FileToIdConverter filetoidconverter = FileToIdConverter.m_246568_((String)directory);
        for (Map.Entry entry : filetoidconverter.m_246760_(resourceManager).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourcelocation1 = filetoidconverter.m_245273_(resourcelocation);
            List value = (List)entry.getValue();
            for (Resource r : value) {
                try (BufferedReader reader = r.m_215508_();){
                    JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                    output.add(jsonelement);
                }
                catch (JsonParseException | IOException | IllegalArgumentException var14) {
                    Moonlight.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)var14);
                }
            }
        }
        return output;
    }

    protected void apply(List<JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList<ColorSetModification> colorSets = new ArrayList<ColorSetModification>();
        for (JsonElement json : object) {
            try {
                ColorSetModification cs = (ColorSetModification)((Pair)ColorSetModification.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, a -> {})).getFirst();
                colorSets.add(cs);
            }
            catch (Exception ex) {
                Moonlight.LOGGER.info("Failed to load custom color set definition {}. Ignoring", (Object)json, (Object)ex);
            }
        }
        this.state = this.state.cloneModified(colorSets);
    }

    public void setup() {
        Stopwatch sw = Stopwatch.createStarted();
        HashMap<String, DyeColor> colors = new HashMap<String, DyeColor>();
        VANILLA_COLORS.forEach(d -> colors.put(d.m_41065_(), (DyeColor)d));
        ArrayList<String> colorPriority = new ArrayList<String>(colors.keySet().stream().toList());
        Map<String, ColoredSet<Block>> blockSets = this.scanRegistryAndDetectSets((Map<String, DyeColor>)colors, (List<String>)colorPriority, (Registry)BuiltInRegistries.f_256975_);
        Map<String, ColoredSet<Item>> itemSets = this.scanRegistryAndDetectSets((Map<String, DyeColor>)colors, (List<String>)colorPriority, (Registry)BuiltInRegistries.f_257033_);
        this.state = this.defaultState = new State(blockSets, itemSets);
        Moonlight.LOGGER.info("Initialized color sets in {}ms", (Object)sw.elapsed().toMillis());
    }

    private <T> Map<String, ColoredSet<T>> scanRegistryAndDetectSets(Map<String, DyeColor> colors, List<String> colorPriority, Registry<T> registry) {
        HashMap<ResourceLocation, ColorSetBuilder> groupedByType = new HashMap<ResourceLocation, ColorSetBuilder>();
        colorPriority.sort(Comparator.comparingInt(String::length));
        Collections.reverse(colorPriority);
        block0: for (Map.Entry e : registry.m_6579_()) {
            ResourceLocation id = ((ResourceKey)e.getKey()).m_135782_();
            String name = id.m_135815_();
            if (!name.contains("_")) continue;
            for (String c : colorPriority) {
                ResourceLocation newId = null;
                if (name.startsWith(c + "_")) {
                    newId = new ResourceLocation(id.m_135827_(), name.substring((c + "_").length()));
                }
                if (name.endsWith("_" + c)) {
                    newId = new ResourceLocation(id.m_135827_(), name.substring(0, name.length() - ("_" + c).length()));
                }
                if (newId == null) continue;
                DyeColor dyeColor = colors.get(c);
                groupedByType.computeIfAbsent(newId, a -> new ColorSetBuilder()).setColor(dyeColor, e.getValue());
                continue block0;
            }
        }
        HashMap<String, ColoredSet<T>> result = new HashMap<String, ColoredSet<T>>();
        for (Map.Entry j : groupedByType.entrySet()) {
            ColorSetBuilder set = (ColorSetBuilder)j.getValue();
            ResourceLocation id = (ResourceLocation)j.getKey();
            if (this.isHardcodedBlacklisted(id) || !set.hasAllVanilla()) continue;
            this.addExtraEntries(id, registry, set);
            result.put(id.toString(), set.build());
        }
        return result;
    }

    private <T> void addExtraEntries(ResourceLocation id, Registry<T> registry, ColorSetBuilder<T> colorsToObj) {
        block0: for (DyeColor c : MODDED_COLORS) {
            String namespace = id.m_135827_();
            String path = id.m_135815_();
            for (String mod : KNOWN_COLOR_MODS) {
                for (String s : new String[]{namespace + ":" + path + "_%s", namespace + ":%s_" + path, mod + ":" + path + "_%s", mod + ":%s_" + path}) {
                    Optional o = registry.m_6612_(new ResourceLocation(String.format(s, c.m_41065_())));
                    if (!o.isPresent()) continue;
                    colorsToObj.setColor(c, o.get());
                    continue block0;
                }
            }
        }
        Optional o = registry.m_6612_(id);
        Object def = o.orElseGet(() -> registry.m_6612_(new ResourceLocation(id.m_135815_())).orElseGet(() -> colorsToObj.getColor(DyeColor.WHITE)));
        colorsToObj.setColor(null, def);
    }

    private boolean isHardcodedBlacklisted(ResourceLocation id) {
        String modId = id.m_135827_();
        return modId.equals("energeticsheep") || modId.equals("xycraft_world") || modId.equals("botania") || modId.equals("spectrum");
    }

    @Nullable
    public DyeColor getColor(Block block) {
        return (DyeColor)this.state.obj2Colors.get((Object)block);
    }

    @Nullable
    public DyeColor getColor(Item item) {
        return (DyeColor)this.state.obj2Colors.get((Object)item);
    }

    @Nullable
    public Item getColoredItem(String key, @Nullable DyeColor color) {
        ColoredSet<Item> set = this.getItemSet(key);
        if (set != null) {
            return set.with(color);
        }
        return null;
    }

    @Nullable
    public Block getColoredBlock(String key, @Nullable DyeColor color) {
        ColoredSet<Block> set = this.getBlockSet(key);
        if (set != null) {
            return set.with(color);
        }
        return null;
    }

    public Set<String> getBlockKeys() {
        return this.state.blockColorSets.keySet();
    }

    public Set<String> getItemKeys() {
        return this.state.itemColorSets.keySet();
    }

    @Nullable
    public Block changeColor(Block old, @Nullable DyeColor newColor) {
        Block b;
        ColoredSet<Block> set;
        String key = this.getKey(old);
        if (key != null && (set = this.getBlockSet(key)) != null && (b = set.with(newColor)) != old) {
            return b;
        }
        return null;
    }

    @Nullable
    public Item changeColor(Item old, @Nullable DyeColor newColor) {
        Item i;
        ColoredSet<Item> set;
        String key = this.getKey(old);
        if (key != null && (set = this.getItemSet(key)) != null && (i = set.with(newColor)) != old) {
            return i;
        }
        return null;
    }

    @Nullable
    public String getKey(Block block) {
        return (String)this.state.obj2Type.get((Object)block);
    }

    @Nullable
    public String getKey(Item item) {
        return (String)this.state.obj2Type.get((Object)item);
    }

    @Nullable
    private ColoredSet<Block> getBlockSet(String key) {
        key = new ResourceLocation(key).toString();
        return this.state.blockColorSets.get(key);
    }

    @Nullable
    private ColoredSet<Item> getItemSet(String key) {
        key = new ResourceLocation(key).toString();
        return this.state.itemColorSets.get(key);
    }

    @Nullable
    public HolderSet<Block> getBlockHolderSet(String key) {
        ColoredSet<Block> set = this.getBlockSet(key);
        if (set != null) {
            return set.makeHolderSet((Registry<Block>)BuiltInRegistries.f_256975_);
        }
        return null;
    }

    @Nullable
    public HolderSet<Item> getItemHolderSet(String key) {
        ColoredSet<Item> set = this.getItemSet(key);
        if (set != null) {
            return set.makeHolderSet((Registry<Item>)BuiltInRegistries.f_257033_);
        }
        return null;
    }

    static class State {
        private final Map<String, ColoredSet<Block>> blockColorSets;
        private final Map<String, ColoredSet<Item>> itemColorSets;
        private final Object2ObjectOpenHashMap<Object, DyeColor> obj2Colors = new Object2ObjectOpenHashMap();
        private final Object2ObjectOpenHashMap<Object, String> obj2Type = new Object2ObjectOpenHashMap();

        private State(Map<String, ColoredSet<Block>> blockColorSets, Map<String, ColoredSet<Item>> itemColorSets) {
            ColoredSet<Block> set;
            String id;
            this.blockColorSets = blockColorSets;
            this.itemColorSets = itemColorSets;
            for (Map.Entry<String, ColoredSet<Block>> entry : blockColorSets.entrySet()) {
                id = entry.getKey();
                set = entry.getValue();
                for (Map.Entry v : set.colorsToObj.entrySet()) {
                    this.obj2Colors.put(v.getValue(), (Object)v.getKey());
                    this.obj2Type.put(v.getValue(), (Object)id);
                }
            }
            for (Map.Entry<String, ColoredSet<Block>> entry : itemColorSets.entrySet()) {
                id = entry.getKey();
                set = entry.getValue();
                for (Map.Entry v : set.colorsToObj.entrySet()) {
                    this.obj2Colors.put(v.getValue(), (Object)v.getKey());
                    this.obj2Type.put(v.getValue(), (Object)id);
                }
            }
        }

        private State cloneModified(List<ColorSetModification> mods) {
            Map blockBuilder = this.blockColorSets.entrySet().stream().map(e -> Map.entry((String)e.getKey(), ColorSetBuilder.from((ColoredSet)e.getValue()))).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), (ColorSetBuilder)e.getValue()), HashMap::putAll);
            Map itemBuilder = this.itemColorSets.entrySet().stream().map(e -> Map.entry((String)e.getKey(), ColorSetBuilder.from((ColoredSet)e.getValue()))).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), (ColorSetBuilder)e.getValue()), HashMap::putAll);
            mods.sort(Comparator.comparingInt(m -> m.replace() ? 1 : 0));
            for (ColorSetModification mod : mods) {
                String id = mod.getId().toString();
                ColorSetBuilder blockSet = null;
                ColorSetBuilder itemSet = null;
                if (mod.hasBlocks()) {
                    if (mod.replace()) {
                        blockBuilder.put(id, new ColorSetBuilder());
                    }
                    blockSet = (ColorSetBuilder)blockBuilder.get(id);
                }
                if (mod.hasItems()) {
                    if (mod.replace()) {
                        itemBuilder.put(id, new ColorSetBuilder());
                    }
                    itemSet = (ColorSetBuilder)itemBuilder.get(id);
                }
                for (Map.Entry<DyeColor, BlockAndItem> e2 : mod.entrySet()) {
                    @Nullable DyeColor color = e2.getKey();
                    @Nullable Block b = e2.getValue().block();
                    @Nullable Item i = e2.getValue().item();
                    if (b != null && blockSet != null) {
                        blockSet.setColor(color, b);
                    }
                    if (i == null || itemSet == null) continue;
                    itemSet.setColor(color, i);
                }
            }
            Map newBlockSets = blockBuilder.entrySet().stream().filter(e -> !((ColorSetBuilder)e.getValue()).isEmpty()).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), ((ColorSetBuilder)e.getValue()).build()), HashMap::putAll);
            Map newItemSets = itemBuilder.entrySet().stream().filter(e -> !((ColorSetBuilder)e.getValue()).isEmpty()).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), ((ColorSetBuilder)e.getValue()).build()), HashMap::putAll);
            return new State(newBlockSets, newItemSets);
        }
    }

    private static class ColorSetBuilder<T> {
        private final Map<DyeColor, T> colorsToObj = new HashMap<DyeColor, T>();

        private ColorSetBuilder() {
        }

        private static <T> ColorSetBuilder<T> from(ColoredSet<T> other) {
            ColorSetBuilder<T> b = new ColorSetBuilder<T>();
            b.colorsToObj.putAll(other.colorsToObj);
            return b;
        }

        private void setColor(@Nullable DyeColor color, T b) {
            this.colorsToObj.put(color, b);
        }

        private boolean isEmpty() {
            return this.colorsToObj.isEmpty();
        }

        private ColoredSet<T> build() {
            return new ColoredSet<T>(this.colorsToObj);
        }

        public boolean hasAllVanilla() {
            return VANILLA_COLORS.stream().allMatch(this.colorsToObj::containsKey);
        }

        @Nullable
        public T getColor(DyeColor dyeColor) {
            return this.colorsToObj.get(dyeColor);
        }
    }

    private record ColoredSet<T>(Map<DyeColor, T> colorsToObj) {
        private ColoredSet(Map<DyeColor, T> colorsToObj) {
            this.colorsToObj = new HashMap<DyeColor, T>(colorsToObj);
        }

        private HolderSet<T> makeHolderSet(Registry<T> registry) {
            return HolderSet.m_205803_(arg_0 -> registry.m_263177_(arg_0), new ArrayList<T>(this.colorsToObj.values()));
        }

        @Nullable
        private T with(@Nullable DyeColor newColor) {
            if (newColor != null && !this.colorsToObj.containsKey(newColor)) {
                return null;
            }
            return this.colorsToObj.getOrDefault(newColor, this.colorsToObj.get(null));
        }
    }
}

