/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.util.LenientListCodec;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class LenientHolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;
    private final Codec<Holder<E>> elementCodec;
    private final Codec<List<Holder<E>>> homogenousListCodec;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> registryAwareCodec;

    private static <E> Codec<List<Holder<E>>> homogenousList(Codec<Holder<E>> holderCodec, boolean disallowInline) {
        Codec codec = Utils.validateCodec(LenientListCodec.of(holderCodec), ExtraCodecs.m_203984_(Holder::m_203376_));
        return disallowInline ? codec : Codec.either(codec, holderCodec).xmap(either -> (List)either.map(list -> list, List::of), list -> list.size() == 1 ? Either.right((Object)((Holder)list.get(0))) : Either.left((Object)list));
    }

    public static <E> Codec<HolderSet<E>> create(ResourceKey<? extends Registry<E>> registryKey, Codec<Holder<E>> holderCodec, boolean disallowInline) {
        return new LenientHolderSetCodec<E>(registryKey, holderCodec, disallowInline);
    }

    private LenientHolderSetCodec(ResourceKey<? extends Registry<E>> registryKey, Codec<Holder<E>> elementCodec, boolean disallowInline) {
        this.registryKey = registryKey;
        this.elementCodec = elementCodec;
        this.homogenousListCodec = LenientHolderSetCodec.homogenousList(elementCodec, disallowInline);
        this.registryAwareCodec = Codec.either((Codec)TagKey.m_203886_(registryKey), this.homogenousListCodec);
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> dynamicOps, T object) {
        RegistryOps registryOps;
        Optional optional;
        if (dynamicOps instanceof RegistryOps && (optional = (registryOps = (RegistryOps)dynamicOps).m_255006_(this.registryKey)).isPresent()) {
            HolderGetter holderGetter = (HolderGetter)optional.get();
            return this.registryAwareCodec.decode(dynamicOps, object).flatMap(pair -> {
                DataResult dataResult = (DataResult)((Either)pair.getFirst()).map(tagKey -> LenientHolderSetCodec.lookupTag(holderGetter, tagKey), list -> DataResult.success((Object)HolderSet.m_205800_((List)list)));
                return dataResult.map(holderSet -> Pair.of((Object)holderSet, (Object)pair.getSecond()));
            });
        }
        return this.decodeWithoutRegistry(dynamicOps, object);
    }

    private static <E> DataResult<HolderSet<E>> lookupTag(HolderGetter<E> input, TagKey<E> tagKey) {
        return input.m_254901_(tagKey).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Missing tag: '" + String.valueOf(tagKey.f_203868_()) + "' in '" + String.valueOf(tagKey.f_203867_().m_135782_()) + "'"));
    }

    public <T> DataResult<T> encode(HolderSet<E> input, DynamicOps<T> ops, T prefix) {
        RegistryOps registryOps;
        Optional optional;
        if (ops instanceof RegistryOps && (optional = (registryOps = (RegistryOps)ops).m_255056_(this.registryKey)).isPresent()) {
            if (!input.m_207277_((HolderOwner)optional.get())) {
                return DataResult.error(() -> "HolderSet " + String.valueOf(input) + " is not valid in current registry set");
            }
            return this.registryAwareCodec.encode((Object)input.m_203440_().mapRight(List::copyOf), ops, prefix);
        }
        return this.encodeWithoutRegistry(input, ops, prefix);
    }

    private <T> DataResult<Pair<HolderSet<E>, T>> decodeWithoutRegistry(DynamicOps<T> ops, T input) {
        return this.elementCodec.listOf().decode(ops, input).flatMap(pair -> {
            ArrayList<Holder.Direct> list = new ArrayList<Holder.Direct>();
            for (Holder holder : (List)pair.getFirst()) {
                if (!(holder instanceof Holder.Direct)) {
                    return DataResult.error(() -> "Can't decode element " + String.valueOf(holder) + " without registry");
                }
                Holder.Direct direct = (Holder.Direct)holder;
                list.add(direct);
            }
            return DataResult.success((Object)new Pair((Object)HolderSet.m_205800_(list), pair.getSecond()));
        });
    }

    private <T> DataResult<T> encodeWithoutRegistry(HolderSet<E> input, DynamicOps<T> ops, T prefix) {
        return this.homogenousListCodec.encode(input.m_203614_().toList(), ops, prefix);
    }
}

