/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.chiseling.preview.render;

import com.google.common.collect.Maps;
import java.util.Map;
import mod.chiselsandbits.api.client.render.preview.chiseling.IChiselContextPreviewRenderer;
import mod.chiselsandbits.api.client.render.preview.chiseling.IChiselContextPreviewRendererRegistry;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.client.chiseling.preview.render.ConfigurableColoredVoxelShapeChiselContextPreviewRenderer;
import mod.chiselsandbits.client.chiseling.preview.render.NoopChiselContextPreviewRenderer;
import net.minecraft.resources.ResourceLocation;

public class ChiselContextPreviewRendererRegistry
implements IChiselContextPreviewRendererRegistry {
    private static final ChiselContextPreviewRendererRegistry INSTANCE = new ChiselContextPreviewRendererRegistry();
    private final Map<ResourceLocation, IChiselContextPreviewRenderer> rendererMap = Maps.newConcurrentMap();

    public static ChiselContextPreviewRendererRegistry getInstance() {
        return INSTANCE;
    }

    private ChiselContextPreviewRendererRegistry() {
        this.register(new ConfigurableColoredVoxelShapeChiselContextPreviewRenderer(), new NoopChiselContextPreviewRenderer());
    }

    @Override
    public IChiselContextPreviewRenderer getCurrent() {
        return this.rendererMap.getOrDefault(new ResourceLocation(IClientConfiguration.getInstance().getPreviewRenderer().get()), this.rendererMap.get(ConfigurableColoredVoxelShapeChiselContextPreviewRenderer.ID));
    }

    @Override
    public IChiselContextPreviewRendererRegistry register(IChiselContextPreviewRenderer ... renderers) {
        for (IChiselContextPreviewRenderer renderer : renderers) {
            if (this.rendererMap.put(renderer.getId(), renderer) == null) continue;
            throw new IllegalArgumentException("The renderer id: " + String.valueOf(renderer.getId()) + " is already in use!");
        }
        return this;
    }
}

