/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.recipe.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.createtweaker.CreateTweakerHelper;
import com.blamejared.createtweaker.recipe.replacement.CreateTweakerRecipeComponents;
import com.blamejared.createtweaker.service.Services;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

public interface IProcessingRecipeHandler<T extends ProcessingRecipe<?>>
extends IRecipeHandler<T> {
    default public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super T> manager, T first, U secondRecipe) {
        if (this.isGoodRecipe(secondRecipe)) {
            ProcessingRecipe second = (ProcessingRecipe)secondRecipe;
            if (first.m_7527_().size() != second.m_7527_().size() || !first.getRequiredHeat().equals((Object)second.getRequiredHeat())) {
                return false;
            }
            return IngredientUtil.doIngredientsConflict((List)first.m_7527_(), (List)second.m_7527_()) && Services.PLATFORM.doFluidIngredientsConflict(first, second);
        }
        return false;
    }

    default public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super T> manager, T recipe) {
        return Optional.of(IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, recipe.m_7527_().stream().map(IIngredient::fromIngredient).toList()).with(BuiltinRecipeComponents.Output.CHANCED_ITEMS, recipe.getRollableResults().stream().map(CreateTweakerHelper::mapProcessingResult).toList()).with(BuiltinRecipeComponents.Input.FLUID_INGREDIENTS, recipe.getFluidIngredients().stream().map(CreateTweakerHelper::mapFluidIngredientsToCT).toList()).with(BuiltinRecipeComponents.Output.FLUIDS, Services.PLATFORM.getRecipeFluidResults((ProcessingRecipe<?>)recipe).stream().toList()).with(BuiltinRecipeComponents.Processing.TIME, (Object)recipe.getProcessingDuration()).with(CreateTweakerRecipeComponents.Input.HEAT, (Object)recipe.getRequiredHeat()).build());
    }

    default public Optional<T> recompose(IRecipeManager<? super T> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(this.factory(), name);
        builder.withItemIngredients(recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS).stream().map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_)));
        builder.withItemOutputs(recipe.getOrThrow(BuiltinRecipeComponents.Output.CHANCED_ITEMS).stream().map(CreateTweakerHelper::mapPercentagedToProcessingOutput).collect(Collectors.toCollection(NonNullList::m_122779_)));
        builder.withFluidIngredients(recipe.getOrThrow(BuiltinRecipeComponents.Input.FLUID_INGREDIENTS).stream().map(CreateTweakerHelper::mapFluidIngredients).collect(Collectors.toCollection(NonNullList::m_122779_)));
        Services.PLATFORM.withFluidOutputs(builder, recipe.getOrThrow(BuiltinRecipeComponents.Output.FLUIDS));
        builder.duration(((Integer)recipe.getOrThrowSingle(BuiltinRecipeComponents.Processing.TIME)).intValue());
        builder.requiresHeat((HeatCondition)recipe.getOrThrowSingle(CreateTweakerRecipeComponents.Input.HEAT));
        return Optional.of(builder.build());
    }

    public boolean isGoodRecipe(Recipe<?> var1);

    public ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory();
}

