/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure;

import com.github.alexmodguy.alexscaves.server.level.structure.ACStructureRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.UndergroundCabinStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;

public class UndergroundCabinStructure
extends Structure {
    public static final Codec<UndergroundCabinStructure> CODEC = UndergroundCabinStructure.m_226607_(settings -> new UndergroundCabinStructure((Structure.StructureSettings)settings));
    private static final ResourceLocation[] CABIN_NBT = new ResourceLocation[]{new ResourceLocation("alexscaves", "underground_cabin_0"), new ResourceLocation("alexscaves", "underground_cabin_1"), new ResourceLocation("alexscaves", "underground_cabin_2"), new ResourceLocation("alexscaves", "underground_cabin_3"), new ResourceLocation("alexscaves", "underground_cabin_4"), new ResourceLocation("alexscaves", "underground_cabin_5"), new ResourceLocation("alexscaves", "underground_cabin_6")};

    public UndergroundCabinStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        LevelHeightAccessor levelHeight = context.f_226629_();
        int y = context.f_226622_().m_214096_(context.f_226628_().m_45604_(), context.f_226628_().m_45605_(), Heightmap.Types.OCEAN_FLOOR_WG, levelHeight, context.f_226624_()) - 20;
        int maxHeight = y - 14 - context.f_226626_().m_188503_(15);
        BlockPos blockpos = new BlockPos(context.f_226628_().m_45604_(), maxHeight, context.f_226628_().m_45605_());
        if (context.f_226623_().m_203407_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), context.f_226624_().m_224579_()).m_203656_(ACTagRegistry.HAS_NO_UNDERGROUND_CABINS)) {
            return Optional.empty();
        }
        ResourceLocation res = (ResourceLocation)Util.m_214670_((Object[])CABIN_NBT, (RandomSource)context.f_226626_());
        return Optional.of(new Structure.GenerationStub(blockpos, piecesBuilder -> piecesBuilder.m_142679_((StructurePiece)new UndergroundCabinStructurePiece(context.f_226625_(), res, blockpos, rotation))));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ACStructureRegistry.UNDERGROUND_CABIN.get();
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }
}

