/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.block.GingerbreadDoorBlock;
import com.github.alexmodguy.alexscaves.server.entity.living.GingerbreadManEntity;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class GingerbreadManOpenDoorGoal
extends Goal {
    protected GingerbreadManEntity gingerbreadMan;
    protected BlockPos doorPos = BlockPos.f_121853_;
    protected boolean hasDoor;
    private boolean passed;
    private float doorOpenDirX;
    private float doorOpenDirZ;
    private int timeSincePassing = 0;

    public GingerbreadManOpenDoorGoal(GingerbreadManEntity gingerbreadMan) {
        this.gingerbreadMan = gingerbreadMan;
    }

    protected boolean isOpen() {
        if (!this.hasDoor) {
            return false;
        }
        BlockState blockstate = this.gingerbreadMan.m_9236_().m_8055_(this.doorPos);
        if (!(blockstate.m_60734_() instanceof GingerbreadDoorBlock)) {
            this.hasDoor = false;
            return false;
        }
        return (Boolean)blockstate.m_61143_((Property)GingerbreadDoorBlock.OPEN);
    }

    protected void setOpen(boolean b) {
        BlockState blockstate;
        if (this.hasDoor && (blockstate = this.gingerbreadMan.m_9236_().m_8055_(this.doorPos)).m_60734_() instanceof GingerbreadDoorBlock) {
            ((GingerbreadDoorBlock)blockstate.m_60734_()).setOpen((Entity)this.gingerbreadMan, this.gingerbreadMan.m_9236_(), blockstate, this.doorPos, b);
        }
    }

    public boolean m_8036_() {
        GroundPathNavigation groundpathnavigation;
        Path path;
        if (!GoalUtils.m_26894_((Mob)this.gingerbreadMan)) {
            return false;
        }
        if (!this.gingerbreadMan.f_19862_) {
            return false;
        }
        PathNavigation pathNavigation = this.gingerbreadMan.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation && (path = (groundpathnavigation = (GroundPathNavigation)pathNavigation).m_26570_()) != null && !path.m_77392_() && groundpathnavigation.m_26492_()) {
            for (int i = 0; i < Math.min(path.m_77399_() + 2, path.m_77398_()); ++i) {
                Node node = path.m_77375_(i);
                this.doorPos = new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_);
                if (this.gingerbreadMan.m_20275_(this.doorPos.m_123341_(), this.gingerbreadMan.m_20186_(), this.doorPos.m_123343_()) > 2.25) continue;
                this.hasDoor = this.gingerbreadMan.m_9236_().m_8055_(this.doorPos).m_60734_() instanceof GingerbreadDoorBlock;
                if (!this.hasDoor) continue;
                return !this.isOpen();
            }
            this.doorPos = this.gingerbreadMan.m_20183_();
            this.hasDoor = this.gingerbreadMan.m_9236_().m_8055_(this.doorPos).m_60734_() instanceof GingerbreadDoorBlock;
            return this.hasDoor && !this.isOpen();
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.passed || this.timeSincePassing < 15;
    }

    public void m_8056_() {
        this.passed = false;
        this.doorOpenDirX = (float)((double)this.doorPos.m_123341_() + 0.5 - this.gingerbreadMan.m_20185_());
        this.doorOpenDirZ = (float)((double)this.doorPos.m_123343_() + 0.5 - this.gingerbreadMan.m_20189_());
        this.timeSincePassing = 0;
    }

    public void m_8041_() {
        this.setOpen(false);
        this.timeSincePassing = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)this.doorPos);
        if (!this.isOpen() && this.gingerbreadMan.m_20238_(vec3) < 4.0) {
            this.gingerbreadMan.m_7618_(EntityAnchorArgument.Anchor.EYES, vec3);
            if (this.gingerbreadMan.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.gingerbreadMan.setAnimation(this.gingerbreadMan.m_217043_().m_188499_() ? GingerbreadManEntity.ANIMATION_SWING_RIGHT : GingerbreadManEntity.ANIMATION_SWING_LEFT);
            }
        }
        if ((this.gingerbreadMan.getAnimation() == GingerbreadManEntity.ANIMATION_SWING_RIGHT || this.gingerbreadMan.getAnimation() == GingerbreadManEntity.ANIMATION_SWING_LEFT) && this.gingerbreadMan.getAnimationTick() == 8) {
            this.setOpen(true);
            this.passed = true;
        }
        if (this.passed) {
            ++this.timeSincePassing;
        }
    }
}

