/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.SirenLightBlockEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SirenLightBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape SHAPE_UP = ACMath.buildShape(Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0));
    private static final VoxelShape SHAPE_DOWN = ACMath.buildShape(Block.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    private static final VoxelShape SHAPE_NORTH = ACMath.buildShape(Block.m_49796_((double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0, (double)14.0), Block.m_49796_((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0));
    private static final VoxelShape SHAPE_SOUTH = ACMath.buildShape(Block.m_49796_((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)10.0), Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)2.0));
    private static final VoxelShape SHAPE_EAST = ACMath.buildShape(Block.m_49796_((double)2.0, (double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0), Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0));
    private static final VoxelShape SHAPE_WEST = ACMath.buildShape(Block.m_49796_((double)6.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), Block.m_49796_((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));

    protected SirenLightBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60913_(1.0f, 12.0f).m_60918_(SoundType.f_56744_).m_60955_().m_60988_().m_60953_(SirenLightBlock.poweredBlockEmission(10)));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    private static ToIntFunction<BlockState> poweredBlockEmission(int light) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? light : 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{FACING, POWERED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case DOWN: {
                return SHAPE_DOWN;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: {
                return SHAPE_EAST;
            }
        }
        return SHAPE_UP;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        return SirenLightBlock.m_152132_(p_152182_, (BlockEntityType)((BlockEntityType)ACBlockEntityRegistry.SIREN_LIGHT.get()), SirenLightBlockEntity::tick);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_) {
            this.updateState(state, worldIn, pos, blockIn);
        }
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!worldIn.f_46443_) {
            this.updateState(state, (Level)worldIn, pos, state.m_60734_());
        }
    }

    public void updateState(BlockState state, Level worldIn, BlockPos pos, Block blockIn) {
        boolean flag = (Boolean)state.m_61143_((Property)POWERED);
        boolean flag1 = worldIn.m_276867_(pos);
        if (flag1 != flag) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag1)), 3);
            worldIn.m_46672_(pos.m_7495_(), (Block)this);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof SirenLightBlockEntity) {
            SirenLightBlockEntity sirenLightBlock = (SirenLightBlockEntity)blockEntity;
            if (!player.m_6144_() && (blockEntity = heldItem.m_41720_()) instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)blockEntity;
                DyeColor dyeColor = dyeItem.m_41089_();
                sirenLightBlock.setColor(dyeColor.m_41071_());
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SirenLightBlockEntity(pos, state);
    }
}

