/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.WaterBoltModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.item.WaterBoltEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WaterBoltRenderer
extends EntityRenderer<WaterBoltEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves", "textures/entity/deep_one/water_bolt.png");
    private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/deep_one/water_bolt_overlay.png");
    private static final WaterBoltModel MODEL = new WaterBoltModel();
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/trail.png");

    public WaterBoltRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(WaterBoltEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        int waterColorAt = ((Biome)entityIn.m_9236_().m_204166_(entityIn.m_20183_()).get()).m_47560_();
        float colorR = (float)(waterColorAt >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(waterColorAt >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(waterColorAt & 0xFF) / 255.0f;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.25, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entityIn.f_19859_, (float)entityIn.m_146908_()) - 180.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_())));
        MODEL.setupAnim(entityIn, 0.0f, 0.0f, (float)entityIn.f_19797_ + partialTicks, 0.0f, 0.0f);
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getBubbledNoCull(TEXTURE));
        MODEL.m_7695_(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, colorR, colorG, colorB, 1.0f);
        VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(ACRenderTypes.getBubbledNoCull(OVERLAY_TEXTURE));
        MODEL.m_7695_(poseStack, ivertexbuilder2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        if (entityIn.hasTrail()) {
            double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
            poseStack.m_85836_();
            poseStack.m_85837_(-x, -y, -z);
            this.renderTrail(entityIn, partialTicks, poseStack, bufferIn, colorR, colorG, colorB, 0.6f, packedLightIn);
            poseStack.m_85849_();
        }
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    private void renderTrail(WaterBoltEntity entityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float trailR, float trailG, float trailB, float trailA, int packedLightIn) {
        int sampleSize = 10;
        float trailHeight = 0.5f;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3(0.0, (double)trailHeight, 0.0).m_82535_(trailZRot);
        Vec3 bottomAngleVec = new Vec3(0.0, (double)(-trailHeight), 0.0).m_82535_(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(ACRenderTypes.getBubbledNoCull(TRAIL_TEXTURE));
        for (int samples = 0; samples < sampleSize; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 2, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            Vec3 draw1 = drawFrom;
            Vec3 draw2 = sample;
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw1.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw1.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_ + (float)bottomAngleVec.f_82479_, (float)draw2.f_82480_ + (float)bottomAngleVec.f_82480_, (float)draw2.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw2.f_82479_ + (float)topAngleVec.f_82479_, (float)draw2.f_82480_ + (float)topAngleVec.f_82480_, (float)draw2.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)draw1.f_82479_ + (float)topAngleVec.f_82479_, (float)draw1.f_82480_ + (float)topAngleVec.f_82480_, (float)draw1.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(trailR, trailG, trailB, trailA).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            drawFrom = sample;
        }
    }

    public ResourceLocation getTextureLocation(WaterBoltEntity entity) {
        return TEXTURE;
    }
}

