/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.event;

import com.leclowndu93150.rpg_potions.config.PotionConfig;
import com.leclowndu93150.rpg_potions.entity.SmokeEmitterEntity;
import com.leclowndu93150.rpg_potions.init.ModEffects;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rpg_potions")
public class SmokeEventHandler {
    @SubscribeEvent
    public static void onPotionImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof ThrownPotion)) {
            return;
        }
        ThrownPotion thrownPotion = (ThrownPotion)projectile;
        Level level = event.getProjectile().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack potionStack = thrownPotion.m_7846_();
        List allEffects = PotionUtils.m_43547_((ItemStack)potionStack);
        MobEffectInstance smokeEffect = null;
        for (MobEffectInstance effect : allEffects) {
            if (effect.m_19544_() != ModEffects.SMOKE.get()) continue;
            smokeEffect = effect;
            break;
        }
        if (smokeEffect == null) {
            return;
        }
        HitResult hitResult = event.getRayTraceResult();
        SmokeEmitterEntity emitter = new SmokeEmitterEntity((Level)serverLevel, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_, smokeEffect.m_19557_());
        serverLevel.m_7967_((Entity)emitter);
        List<MobEffectInstance> remainingEffects = allEffects.stream().filter(e -> e.m_19544_() != ModEffects.SMOKE.get()).toList();
        if (remainingEffects.isEmpty()) {
            event.setCanceled(true);
            thrownPotion.m_146870_();
        } else {
            ItemStack newStack = new ItemStack((ItemLike)potionStack.m_41720_());
            newStack.m_41751_(potionStack.m_41783_() != null ? potionStack.m_41783_().m_6426_() : null);
            PotionUtils.m_43549_((ItemStack)newStack, (Potion)Potions.f_43599_);
            PotionUtils.m_43552_((ItemStack)newStack, remainingEffects);
            if (potionStack.m_41788_()) {
                newStack.m_41714_(potionStack.m_41786_());
            }
            thrownPotion.m_37446_(newStack);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        Level level;
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)ModEffects.SMOKE.get()) && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int radius = (Integer)PotionConfig.SMOKE_RADIUS.get();
            int density = (Integer)PotionConfig.SMOKE_PARTICLE_DENSITY.get();
            for (int i = 0; i < density; ++i) {
                double theta = entity.m_217043_().m_188500_() * 2.0 * Math.PI;
                double phi = Math.acos(2.0 * entity.m_217043_().m_188500_() - 1.0);
                double r = Math.cbrt(entity.m_217043_().m_188500_()) * (double)radius;
                double offsetX = r * Math.sin(phi) * Math.cos(theta);
                double offsetY = r * Math.sin(phi) * Math.sin(theta);
                double offsetZ = r * Math.cos(phi);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, entity.m_20185_() + offsetX, entity.m_20186_() + offsetY, entity.m_20189_() + offsetZ, 1, 0.0, 0.05, 0.0, 0.005);
            }
        }
    }
}

