/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.event;

import com.leclowndu93150.rpg_potions.config.PotionConfig;
import com.leclowndu93150.rpg_potions.init.ModEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rpg_potions")
public class ProjectileReboundEventHandler {
    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity shooter;
        LivingEntity livingTarget;
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHit = (EntityHitResult)hitResult;
        Projectile projectile = event.getProjectile();
        Entity target = entityHit.m_82443_();
        if (target instanceof LivingEntity && (livingTarget = (LivingEntity)target).m_21023_((MobEffect)ModEffects.PROJECTILE_REBOUND.get()) && (shooter = projectile.m_19749_()) != null && shooter != target) {
            event.setCanceled(true);
            Vec3 direction = shooter.m_20182_().m_82546_(projectile.m_20182_()).m_82541_();
            projectile.m_20256_(direction.m_82490_(1.5));
            projectile.m_5602_(target);
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                if (!((Boolean)PotionConfig.PROJECTILE_REBOUND_FULL_DAMAGE.get()).booleanValue()) {
                    arrow.m_36781_(arrow.m_36789_() * 0.75);
                }
            }
        }
    }
}

