/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.event;

import com.leclowndu93150.rpg_potions.config.PotionConfig;
import com.leclowndu93150.rpg_potions.init.ModEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rpg_potions")
public class PhantomArmorEventHandler {
    private static final String HITS_BLOCKED_TAG = "rpg_potions:phantom_armor_hits";

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() == ModEffects.PHANTOM_ARMOR.get()) {
            event.getEntity().getPersistentData().m_128405_(HITS_BLOCKED_TAG, 0);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() == ModEffects.PHANTOM_ARMOR.get()) {
            event.getEntity().getPersistentData().m_128473_(HITS_BLOCKED_TAG);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        int maxHits;
        int hitsBlocked;
        LivingEntity entity = event.getEntity();
        CompoundTag data = entity.getPersistentData();
        if (entity.m_21023_((MobEffect)ModEffects.PHANTOM_ARMOR.get()) && (hitsBlocked = data.m_128451_(HITS_BLOCKED_TAG)) < (maxHits = ((Integer)PotionConfig.PHANTOM_ARMOR_HITS.get()).intValue())) {
            event.setAmount(0.0f);
            data.m_128405_(HITS_BLOCKED_TAG, hitsBlocked + 1);
            if (hitsBlocked + 1 >= maxHits) {
                entity.m_21195_((MobEffect)ModEffects.PHANTOM_ARMOR.get());
            }
        }
    }
}

