/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.event;

import com.leclowndu93150.rpg_potions.config.PotionConfig;
import com.leclowndu93150.rpg_potions.init.ModEffects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rpg_potions")
public class HeatMarkEventHandler {
    private static final String CASTER_UUID_TAG = "rpg_potions:heat_mark_caster";

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance.m_19544_() == ModEffects.HEAT_MARK.get() && (entity = event.getEffectSource()) instanceof LivingEntity) {
            LivingEntity caster = (LivingEntity)entity;
            System.out.println("Heat Mark applied to entity: " + entity2.m_20148_() + " by caster: " + caster.m_20148_());
            CompoundTag data = entity2.getPersistentData();
            data.m_128362_(CASTER_UUID_TAG, caster.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onEffectRevmoed(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() == ModEffects.HEAT_MARK.get()) {
            entity.m_146915_(false);
            entity.getPersistentData().m_128473_(CASTER_UUID_TAG);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        if (event.getEffectInstance().m_19544_() == ModEffects.HEAT_MARK.get()) {
            entity.m_146915_(false);
            entity.getPersistentData().m_128473_(CASTER_UUID_TAG);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Entity entity;
        CompoundTag data;
        LivingEntity entity2 = event.getEntity();
        if (entity2.m_21023_((MobEffect)ModEffects.HEAT_MARK.get()) && (data = entity2.getPersistentData()).m_128403_(CASTER_UUID_TAG) && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            UUID casterUUID = data.m_128342_(CASTER_UUID_TAG);
            if (attacker.m_20148_().equals(casterUUID)) {
                float damage = event.getAmount();
                event.setAmount((float)((double)damage * (Double)PotionConfig.HEAT_MARK_DAMAGE_MULTIPLIER.get()));
            }
        }
    }
}

