/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.entity;

import com.leclowndu93150.rpg_potions.init.ModEntities;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DecoyEntity
extends PathfinderMob {
    private static final EntityDataAccessor<String> PLAYER_NAME = SynchedEntityData.m_135353_(DecoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> PLAYER_SKIN = SynchedEntityData.m_135353_(DecoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> PLAYER_UUID = SynchedEntityData.m_135353_(DecoyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int lifeTicks = 0;
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> inventoryItems = NonNullList.m_122780_((int)41, (Object)ItemStack.f_41583_);

    public DecoyEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public DecoyEntity(Level level, Player player) {
        super((EntityType)ModEntities.DECOY.get(), level);
        this.f_19804_.m_135381_(PLAYER_NAME, (Object)player.m_7755_().getString());
        this.f_19804_.m_135381_(PLAYER_SKIN, (Object)player.m_36316_().getName());
        this.f_19804_.m_135381_(PLAYER_UUID, (Object)player.m_20148_().toString());
        this.m_6593_(player.m_7755_());
        this.m_20340_(false);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack item = player.m_6844_(slot).m_41777_();
            if (slot.m_20743_() == EquipmentSlot.Type.HAND) {
                this.handItems.set(slot.m_20749_(), (Object)item);
                continue;
            }
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            this.armorItems.set(slot.m_20749_(), (Object)item);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            this.inventoryItems.set(i, (Object)player.m_150109_().m_8020_(i).m_41777_());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLAYER_NAME, (Object)"");
        this.f_19804_.m_135372_(PLAYER_SKIN, (Object)"");
        this.f_19804_.m_135372_(PLAYER_UUID, (Object)"");
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LifeTicks", this.lifeTicks);
        compound.m_128359_("PlayerName", (String)this.f_19804_.m_135370_(PLAYER_NAME));
        compound.m_128359_("PlayerSkin", (String)this.f_19804_.m_135370_(PLAYER_SKIN));
        compound.m_128359_("PlayerUUID", (String)this.f_19804_.m_135370_(PLAYER_UUID));
        ListTag armorList = new ListTag();
        for (Object stack : this.armorItems) {
            CompoundTag tag = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(tag);
            }
            armorList.add((Object)tag);
        }
        compound.m_128365_("ArmorItems", (Tag)armorList);
        ListTag handList = new ListTag();
        for (ItemStack stack : this.handItems) {
            CompoundTag tag = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(tag);
            }
            handList.add((Object)tag);
        }
        compound.m_128365_("HandItems", (Tag)handList);
        ListTag inventoryList = new ListTag();
        for (ItemStack stack : this.inventoryItems) {
            CompoundTag tag = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(tag);
            }
            inventoryList.add((Object)tag);
        }
        compound.m_128365_("InventoryItems", (Tag)inventoryList);
    }

    public void m_7378_(CompoundTag compound) {
        int i;
        super.m_7378_(compound);
        this.lifeTicks = compound.m_128451_("LifeTicks");
        this.f_19804_.m_135381_(PLAYER_NAME, (Object)compound.m_128461_("PlayerName"));
        this.f_19804_.m_135381_(PLAYER_SKIN, (Object)compound.m_128461_("PlayerSkin"));
        this.f_19804_.m_135381_(PLAYER_UUID, (Object)compound.m_128461_("PlayerUUID"));
        if (compound.m_128425_("ArmorItems", 9)) {
            ListTag armorList = compound.m_128437_("ArmorItems", 10);
            for (i = 0; i < armorList.size() && i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)ItemStack.m_41712_((CompoundTag)armorList.m_128728_(i)));
            }
        }
        if (compound.m_128425_("HandItems", 9)) {
            ListTag handList = compound.m_128437_("HandItems", 10);
            for (i = 0; i < handList.size() && i < this.handItems.size(); ++i) {
                this.handItems.set(i, (Object)ItemStack.m_41712_((CompoundTag)handList.m_128728_(i)));
            }
        }
        if (compound.m_128425_("InventoryItems", 9)) {
            ListTag inventoryList = compound.m_128437_("InventoryItems", 10);
            for (i = 0; i < inventoryList.size() && i < this.inventoryItems.size(); ++i) {
                this.inventoryItems.set(i, (Object)ItemStack.m_41712_((CompoundTag)inventoryList.m_128728_(i)));
            }
        }
    }

    public String getPlayerName() {
        return (String)this.f_19804_.m_135370_(PLAYER_NAME);
    }

    public String getPlayerSkin() {
        return (String)this.f_19804_.m_135370_(PLAYER_SKIN);
    }

    public UUID getPlayerUUID() {
        String uuidStr = (String)this.f_19804_.m_135370_(PLAYER_UUID);
        if (uuidStr == null || uuidStr.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (slot.m_20743_() == EquipmentSlot.Type.HAND) {
            return (ItemStack)this.handItems.get(slot.m_20749_());
        }
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            return (ItemStack)this.armorItems.get(slot.m_20749_());
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        if (slot.m_20743_() == EquipmentSlot.Type.HAND) {
            this.handItems.set(slot.m_20749_(), (Object)stack);
        } else if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            this.armorItems.set(slot.m_20749_(), (Object)stack);
        }
    }

    public NonNullList<ItemStack> getArmorItems() {
        return this.armorItems;
    }

    public NonNullList<ItemStack> getHandItems() {
        return this.handItems;
    }

    public NonNullList<ItemStack> getInventoryItems() {
        return this.inventoryItems;
    }
}

