/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.client.renderer;

import com.leclowndu93150.rpg_potions.entity.DecoyEntity;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DecoyRenderer
extends MobRenderer<DecoyEntity, PlayerModel<DecoyEntity>> {
    private final Map<String, ResourceLocation> skinCache = new ConcurrentHashMap<String, ResourceLocation>();

    public DecoyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(DecoyEntity entity) {
        UUID playerUUID = entity.getPlayerUUID();
        String playerName = entity.getPlayerSkin();
        if (playerUUID == null || playerName == null || playerName.isEmpty()) {
            return new ResourceLocation("minecraft", "textures/entity/player/wide/steve.png");
        }
        String cacheKey = playerUUID.toString();
        return this.skinCache.computeIfAbsent(cacheKey, uuid -> {
            try {
                GameProfile profile = new GameProfile(playerUUID, playerName);
                Minecraft mc = Minecraft.m_91087_();
                mc.m_91109_().m_118817_(profile, (type, location, texture) -> {
                    if (type == MinecraftProfileTexture.Type.SKIN) {
                        this.skinCache.put(cacheKey, location);
                    }
                }, true);
                ResourceLocation cached = this.skinCache.get(cacheKey);
                if (cached != null) {
                    return cached;
                }
                return new ResourceLocation("minecraft", "textures/entity/player/wide/steve.png");
            }
            catch (Exception e) {
                return new ResourceLocation("minecraft", "textures/entity/player/wide/steve.png");
            }
        });
    }

    public void render(DecoyEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

