/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.hooks;

import com.google.common.base.Predicates;
import com.ldtteam.blockui.hooks.HookManager;
import com.ldtteam.blockui.hooks.IGuiActionCallback;
import com.ldtteam.blockui.hooks.IGuiHookable;
import com.ldtteam.blockui.hooks.TriggerMechanism;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class HookRegistries {
    public static final EntityReg ENTITY_HOOKS = new EntityReg();
    public static final BlockEntityReg BLOCK_ENTITY_HOOKS = new BlockEntityReg();
    private static final HookManager<?, ?, ?>[] REGISTRIES = new HookManager[]{BLOCK_ENTITY_HOOKS, ENTITY_HOOKS};

    public static void tick(long ticks) {
        for (int i = 0; i < REGISTRIES.length; ++i) {
            REGISTRIES[i].tick(ticks);
        }
    }

    public static void render(PoseStack matrixStack, float partialTicks) {
        for (int i = 0; i < REGISTRIES.length; ++i) {
            REGISTRIES[i].render(matrixStack, partialTicks);
        }
    }

    public static class EntityReg
    extends HookManager<Entity, EntityType<?>, Entity> {
        private EntityReg() {
            super(ForgeRegistries.ENTITY_TYPES);
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism trigger) {
            this.register(targetThing, guiLoc, 0L, trigger);
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger) {
            this.register(targetThing, guiLoc, expirationTime, trigger, (rec$, x$0) -> ((IGuiHookable)rec$).shouldOpen((TriggerMechanism)x$0), (rec$, x$0, x$1) -> ((IGuiHookable)rec$).onOpen(x$0, x$1), (rec$, x$0, x$1) -> ((IGuiHookable)rec$).onClose(x$0, x$1));
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism trigger, @Nullable BiPredicate<T, TriggerMechanism> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.register(targetThing, guiLoc, 0L, trigger, shouldOpen, onOpen, onClose);
        }

        public <T extends Entity> void register(EntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger, @Nullable BiPredicate<T, TriggerMechanism> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.registerInternal(targetThing, guiLoc, expirationTime, trigger, shouldOpen, onOpen, onClose);
        }

        @Override
        protected List<Entity> findTriggered(EntityType<?> entityType, TriggerMechanism trigger) {
            Minecraft mc = Minecraft.m_91087_();
            if (trigger instanceof TriggerMechanism.RangeTriggerMechanism) {
                TriggerMechanism.RangeTriggerMechanism rangeTrigger = (TriggerMechanism.RangeTriggerMechanism)trigger;
                return mc.f_91073_.m_142425_(entityType, mc.f_91074_.m_20191_().m_82400_(rangeTrigger.getSearchRange()), (Predicate)Predicates.alwaysTrue());
            }
            if (trigger instanceof TriggerMechanism.RayTraceTriggerMechanism) {
                EntityHitResult entityHitResult;
                Entity entity;
                HitResult hitResult;
                if (mc.f_91077_ != null && (hitResult = mc.f_91077_) instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)hitResult).m_82443_()).m_6095_() == entityType) {
                    return Arrays.asList(entity);
                }
                return Collections.emptyList();
            }
            throw new IllegalArgumentException("No trigger mechanism for Entity and " + trigger.getName() + " trigger.");
        }

        @Override
        protected Entity keyMapper(Entity thing) {
            return thing;
        }

        @Override
        protected void translateToGuiBottomCenter(PoseStack ms, Entity entity, float partialTicks) {
            double x = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
            ms.m_85837_(x, y + (double)entity.m_20206_() + 0.3, z);
        }
    }

    public static class BlockEntityReg
    extends HookManager<BlockEntity, BlockEntityType<?>, BlockPos> {
        private BlockEntityReg() {
            super(ForgeRegistries.BLOCK_ENTITY_TYPES);
        }

        public <T extends BlockEntity> void register(BlockEntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism trigger) {
            this.register(targetThing, guiLoc, 0L, trigger);
        }

        public <T extends BlockEntity> void register(BlockEntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger) {
            this.register(targetThing, guiLoc, expirationTime, trigger, (rec$, x$0) -> ((IGuiHookable)rec$).shouldOpen((TriggerMechanism)x$0), (rec$, x$0, x$1) -> ((IGuiHookable)rec$).onOpen(x$0, x$1), (rec$, x$0, x$1) -> ((IGuiHookable)rec$).onClose(x$0, x$1));
        }

        public <T extends BlockEntity> void register(BlockEntityType<T> targetThing, ResourceLocation guiLoc, TriggerMechanism trigger, @Nullable BiPredicate<T, TriggerMechanism> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.register(targetThing, guiLoc, 0L, trigger, shouldOpen, onOpen, onClose);
        }

        public <T extends BlockEntity> void register(BlockEntityType<T> targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger, @Nullable BiPredicate<T, TriggerMechanism> shouldOpen, @Nullable IGuiActionCallback<T> onOpen, @Nullable IGuiActionCallback<T> onClose) {
            this.registerInternal(targetThing, guiLoc, expirationTime, trigger, shouldOpen, onOpen, onClose);
        }

        @Override
        protected List<BlockEntity> findTriggered(BlockEntityType<?> teType, TriggerMechanism trigger) {
            Minecraft mc = Minecraft.m_91087_();
            if (trigger instanceof TriggerMechanism.RangeTriggerMechanism) {
                TriggerMechanism.RangeTriggerMechanism rangeTrigger = (TriggerMechanism.RangeTriggerMechanism)trigger;
                AABB aabb = mc.f_91074_.m_20191_().m_82400_(rangeTrigger.getSearchRange());
                int xStart = Mth.m_14107_((double)(aabb.f_82288_ / 16.0));
                int xEnd = Mth.m_14165_((double)(aabb.f_82291_ / 16.0));
                int zStart = Mth.m_14107_((double)(aabb.f_82290_ / 16.0));
                int zEnd = Mth.m_14165_((double)(aabb.f_82293_ / 16.0));
                ArrayList<BlockEntity> targets = new ArrayList<BlockEntity>();
                for (int chunkX = xStart; chunkX < xEnd; ++chunkX) {
                    for (int chunkZ = zStart; chunkZ < zEnd; ++chunkZ) {
                        LevelChunk chunk = mc.f_91073_.m_7726_().m_62227_(chunkX, chunkZ, false);
                        if (chunk == null) continue;
                        for (Map.Entry entry : chunk.m_62954_().entrySet()) {
                            BlockPos bp = (BlockPos)entry.getKey();
                            BlockEntity te = (BlockEntity)entry.getValue();
                            if (te.m_58903_() != teType || !((double)bp.m_123341_() > aabb.f_82288_) || !((double)bp.m_123341_() < aabb.f_82291_) || !((double)bp.m_123342_() > aabb.f_82289_) || !((double)bp.m_123342_() < aabb.f_82292_) || !((double)bp.m_123343_() > aabb.f_82290_) || !((double)bp.m_123343_() < aabb.f_82293_)) continue;
                            targets.add(te);
                        }
                    }
                }
                return targets;
            }
            if (trigger instanceof TriggerMechanism.RayTraceTriggerMechanism) {
                BlockHitResult blockHitResult;
                BlockEntity te;
                HitResult xStart;
                if (mc.f_91077_ != null && (xStart = mc.f_91077_) instanceof BlockHitResult && (te = mc.f_91073_.m_7702_((blockHitResult = (BlockHitResult)xStart).m_82425_())) != null && te.m_58903_() == teType) {
                    return Arrays.asList(te);
                }
                return Collections.emptyList();
            }
            throw new IllegalArgumentException("No trigger mechanism for BlockEntity and " + trigger.getName() + " trigger.");
        }

        @Override
        protected BlockPos keyMapper(BlockEntity thing) {
            return thing.m_58899_();
        }

        @Override
        protected void translateToGuiBottomCenter(PoseStack ms, BlockEntity thing, float partialTicks) {
            ms.m_85837_((double)thing.m_58899_().m_123341_() + 0.5, (double)thing.m_58899_().m_123342_() + 1.1, (double)thing.m_58899_().m_123343_() + 0.5);
        }
    }
}

