/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.effects.screen_shake;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeContext;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeEffect;

public interface ModScreenShakeHandler {
    public void tick(Minecraft var1);

    public void addEffect(ScreenShakeEffect var1);

    public void clearEffects();

    public void applyEffects(ScreenShakeContext var1);

    public static class Impl
    implements ModScreenShakeHandler {
        protected final Set<ScreenShakeEffect> delayedShakes = new LinkedHashSet<ScreenShakeEffect>();
        protected Vec3 velocity = Vec3.f_82478_;
        protected Vec3 acceleration = Vec3.f_82478_;
        protected Vec3 displacement = Vec3.f_82478_;
        protected final Random random = new Random();

        @Override
        public void tick(Minecraft minecraft) {
            Iterator<ScreenShakeEffect> iter = this.delayedShakes.iterator();
            while (iter.hasNext()) {
                ScreenShakeEffect effect = iter.next();
                if (!effect.tick()) continue;
                this.immediatelyAddEffect(effect);
                iter.remove();
            }
            int iterations = 10;
            double dt = 1.0 / (double)iterations;
            double restitution = Math.max(0.005, this.getRestitution());
            double drag = Math.max(0.005, this.getDrag());
            for (int i = 0; i < iterations; ++i) {
                Vec3 newRotationDisplacement = this.displacement.m_82549_(this.velocity.m_82490_(dt)).m_82549_(this.acceleration.m_82490_(0.5 * dt * dt));
                Vec3 newAccel = this.displacement.m_82490_(-restitution).m_82549_(this.velocity.m_82490_(-drag));
                Vec3 newVel = this.velocity.m_82549_(this.acceleration.m_82549_(newAccel).m_82490_(0.5 * dt));
                this.displacement = newRotationDisplacement;
                this.velocity = newVel;
                this.acceleration = newAccel;
                this.applyConstraints();
            }
            if (this.displacement.m_82556_() < 1.0E-4 && this.velocity.m_82556_() < 1.0E-4 && this.acceleration.m_82556_() < 1.0E-4) {
                this.clearEffects();
            }
        }

        @Override
        public void applyEffects(ScreenShakeContext context) {
            float partialTicks = context.partialTicks();
            Vec3 currentDisp = this.displacement.m_82549_(this.velocity.m_82490_((double)partialTicks)).m_82549_(this.acceleration.m_82490_((double)(partialTicks * partialTicks) * 0.5));
            context.setDeltaYaw(context.getDeltaYaw() + (float)currentDisp.f_82479_);
            context.setDeltaPitch(context.getDeltaPitch() + (float)currentDisp.f_82480_);
            context.setDeltaRoll(context.getDeltaRoll() + (float)currentDisp.f_82481_);
        }

        @Override
        public void addEffect(ScreenShakeEffect effect) {
            if (effect.duration <= 0) {
                this.immediatelyAddEffect(effect);
            } else {
                this.delayedShakes.add(effect);
            }
        }

        protected void immediatelyAddEffect(ScreenShakeEffect effect) {
            ScreenShakeEffect modified = this.modifyScreenShake(effect);
            double dy = (double)modified.yawMagnitude * (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
            double dp = (double)modified.pitchMagnitude * (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
            double dr = (double)modified.rollMagnitude * (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
            this.velocity = this.velocity.m_82520_(dy, dp, dr);
        }

        @Override
        public void clearEffects() {
            this.displacement = Vec3.f_82478_;
            this.velocity = Vec3.f_82478_;
            this.acceleration = Vec3.f_82478_;
        }

        protected ScreenShakeEffect modifyScreenShake(ScreenShakeEffect effect) {
            return effect;
        }

        protected double getRestitution() {
            return 0.1;
        }

        protected double getDrag() {
            return 0.2;
        }

        protected void applyConstraints() {
        }
    }
}

