/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.oil_barrel;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.content.oil_barrel.OilBarrelBlockEntity;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.ForgeSoundType;

public class OilBarrelBlock
extends Block
implements IBE<OilBarrelBlockEntity>,
IWrenchable {
    public static final EnumProperty<OilBarrelColor> OIL_BARREL_COLOR = EnumProperty.m_61587_((String)"color", OilBarrelColor.class);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final SoundType SILENCED_METAL = new ForgeSoundType(0.1f, 1.5f, () -> SoundEvents.f_12062_, () -> SoundEvents.f_12068_, () -> SoundEvents.f_12065_, () -> SoundEvents.f_12064_, () -> SoundEvents.f_12063_);

    public OilBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(OIL_BARREL_COLOR, (Comparable)((Object)OilBarrelColor.NONE)));
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, OilBarrelBlockEntity::updateConnectivity);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()));
        if (state.m_60734_() instanceof OilBarrelBlock && !context.m_43723_().m_6144_()) {
            return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
        }
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OIL_BARREL_COLOR, AXIS});
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof OilBarrelBlockEntity)) {
                return;
            }
            OilBarrelBlockEntity tankBE = (OilBarrelBlockEntity)be;
            world.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockEntity be;
        if (context.m_43719_().m_122434_() != state.m_61143_(AXIS) && (be = context.m_43725_().m_7702_(context.m_8083_())) instanceof OilBarrelBlockEntity) {
            OilBarrelBlockEntity tankBE = (OilBarrelBlockEntity)be;
            context.m_43725_().m_46747_(context.m_8083_());
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
        return super.onWrenched(state, context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (!(item instanceof DyeItem)) {
            return InteractionResult.PASS;
        }
        DyeItem di = (DyeItem)item;
        OilBarrelColor color = OilBarrelColor.getForDyeColor(di.m_41089_());
        if (state.m_61143_(OIL_BARREL_COLOR) == color) {
            OilBarrelBlockEntity be;
            OilBarrelBlockEntity controllerBE;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof OilBarrelBlockEntity && (controllerBE = (be = (OilBarrelBlockEntity)blockEntity).getControllerBE()) != null) {
                boolean successful = false;
                for (int x = 0; x < controllerBE.getWidth(); ++x) {
                    for (int z = 0; z < controllerBE.getWidth(); ++z) {
                        BlockPos offsetPos = state.m_61143_(AXIS) == Direction.Axis.X ? new BlockPos(pos.m_123341_(), be.getController().m_123342_() + x, be.getController().m_123343_() + z) : (state.m_61143_(AXIS) == Direction.Axis.Y ? be.getController().m_7918_(x, 0, z).m_175288_(pos.m_123342_()) : new BlockPos(be.getController().m_123341_() + x, be.getController().m_123342_() + z, pos.m_123343_()));
                        BlockState blockState = level.m_8055_(offsetPos);
                        if (!(blockState.m_60734_() instanceof OilBarrelBlock) || stack.m_41619_() || blockState.m_61143_(OIL_BARREL_COLOR) == color) continue;
                        level.m_46597_(offsetPos, (BlockState)state.m_61124_(OIL_BARREL_COLOR, (Comparable)((Object)color)));
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        successful = true;
                    }
                }
                if (successful) {
                    return InteractionResult.SUCCESS;
                }
            }
        } else {
            level.m_46597_(pos, (BlockState)state.m_61124_(OIL_BARREL_COLOR, (Comparable)((Object)color)));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Class<OilBarrelBlockEntity> getBlockEntityClass() {
        return OilBarrelBlockEntity.class;
    }

    public BlockEntityType<? extends OilBarrelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.OIL_BARREL.get();
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public static enum OilBarrelColor implements StringRepresentable
    {
        WHITE(DyeColor.WHITE),
        ORANGE(DyeColor.ORANGE),
        MAGENTA(DyeColor.MAGENTA),
        LIGHT_BLUE(DyeColor.LIGHT_BLUE),
        YELLOW(DyeColor.YELLOW),
        LIME(DyeColor.LIME),
        PINK(DyeColor.PINK),
        GRAY(DyeColor.GRAY),
        LIGHT_GRAY(DyeColor.LIGHT_GRAY),
        CYAN(DyeColor.CYAN),
        PURPLE(DyeColor.PURPLE),
        BLUE(DyeColor.BLUE),
        BROWN(DyeColor.BROWN),
        GREEN(DyeColor.GREEN),
        RED(DyeColor.RED),
        BLACK(DyeColor.BLACK),
        NONE(null);

        public DyeColor dyeColor;

        private OilBarrelColor(DyeColor dyeColor) {
            this.dyeColor = dyeColor;
        }

        public static OilBarrelColor getForDyeColor(DyeColor dyeColor) {
            for (OilBarrelColor value : (OilBarrelColor[])OilBarrelColor.class.getEnumConstants()) {
                if (value.dyeColor != dyeColor) continue;
                return value;
            }
            return NONE;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

