/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.huge;

import com.jesz.createdieselgenerators.CDGPartialModels;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.PoweredEngineShaftBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class HugeDieselEngineInstance
extends AbstractBlockEntityVisual<HugeDieselEngineBlockEntity>
implements SimpleDynamicVisual {
    protected final TransformedInstance piston = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CDGPartialModels.ENGINE_PISTON)).createInstance();
    protected final TransformedInstance connector = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CDGPartialModels.ENGINE_PISTON_CONNECTOR)).createInstance();
    protected final TransformedInstance linkage = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CDGPartialModels.ENGINE_PISTON_LINKAGE)).createInstance();

    public HugeDieselEngineInstance(VisualizationContext context, HugeDieselEngineBlockEntity blockEntity, float pt) {
        super(context, (BlockEntity)blockEntity, pt);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float shaftR;
        boolean roll90;
        Float angle = ((HugeDieselEngineBlockEntity)this.blockEntity).getTargetAngle();
        BlockState state = ((HugeDieselEngineBlockEntity)this.blockEntity).m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING);
        Direction.Axis facingAxis = facing.m_122434_();
        if (angle == null) {
            this.transformed(this.piston, facing, false).translate(0.0, 0.53475, 0.0);
            this.linkage.setZeroTransform().setChanged();
            this.connector.setZeroTransform().setChanged();
            this.piston.setChanged();
            return;
        }
        PoweredEngineShaftBlockEntity shaft = ((HugeDieselEngineBlockEntity)this.blockEntity).getShaft();
        if (shaft == null) {
            this.transformed(this.piston, facing, false).translate(0.0, 0.53475, 0.0);
            this.linkage.setZeroTransform().setChanged();
            this.connector.setZeroTransform().setChanged();
            this.piston.setChanged();
            return;
        }
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        boolean bl = roll90 = facingAxis.m_122479_() && axis == Direction.Axis.Y || facingAxis.m_122478_() && axis == Direction.Axis.Z;
        float f = facing == Direction.DOWN ? -90.0f : (facing == Direction.UP ? 90.0f : (facing == Direction.WEST ? -90.0f : (shaftR = facing == Direction.EAST ? 90.0f : 0.0f)));
        if (roll90) {
            shaftR = facing == Direction.NORTH ? 180.0f : (facing == Direction.SOUTH ? 0.0f : (facing == Direction.EAST ? -90.0f : (facing == Direction.WEST ? 90.0f : 0.0f)));
        }
        angle = Float.valueOf(angle.floatValue() + (float)((double)shaftR * Math.PI / 180.0));
        float sine = Mth.m_14031_((float)angle.floatValue()) * (float)(((Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING)).m_122434_() == Direction.Axis.Y ? -1 : 1);
        float sine2 = Mth.m_14031_((float)(angle.floatValue() - 1.5707964f)) * (float)(((Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING)).m_122434_() == Direction.Axis.Y ? -1 : 1);
        float pistonOffset = (1.0f - sine) / 4.0f + 0.4375f;
        this.transformed(this.piston, facing, roll90).translate(0.0f, pistonOffset, 0.0f);
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.transformed(this.linkage, facing, roll90).center()).translate(0.0f, 1.0f, 0.0f).uncenter()).translate(0.0f, pistonOffset, 0.0f).translate(0.0f, 0.25f, 0.5f).rotateXDegrees(sine2 * 23.0f)).translate(0.0f, -0.25f, -0.5f);
        if (shaft.isEngineForConnectorDisplay(((HugeDieselEngineBlockEntity)this.blockEntity).m_58899_())) {
            ((TransformedInstance)this.transformed(this.connector, facing, roll90).translate(0.0f, 2.0f, 0.0f).center()).rotateX((float)((double)(-angle.floatValue() + 1.5707964f) - (facingAxis.m_122478_() ? Math.PI : 0.0))).uncenter();
        } else {
            this.connector.setZeroTransform();
        }
        this.linkage.setChanged();
        this.connector.setChanged();
        this.piston.setChanged();
    }

    protected TransformedInstance transformed(TransformedInstance modelData, Direction facing, boolean roll90) {
        return (TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)modelData.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing) + 90.0f)).rotateYDegrees(roll90 ? -90.0f : 0.0f)).uncenter();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.piston);
        consumer.accept((Instance)this.linkage);
        consumer.accept((Instance)this.connector);
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.piston, this.linkage, this.connector});
    }

    protected void _delete() {
        this.piston.delete();
        this.linkage.delete();
        this.connector.delete();
    }
}

