/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.automessage.core.abstraction;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import forge.com.cursee.automessage.Constants;
import forge.com.cursee.automessage.core.ClientMessageService;
import forge.com.cursee.automessage.core.ServerMessageService;
import forge.com.cursee.automessage.core.abstraction.IMessageService;
import forge.com.cursee.automessage.core.message.Message;
import forge.com.cursee.automessage.core.message.MessageSchedule;
import forge.com.cursee.automessage.core.message.MessageServiceUtil;
import forge.com.cursee.automessage.platform.Services;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractMessageService
implements IMessageService {
    public abstract LinkedList<String> getMessageJsonFiles();

    public abstract AbstractMessageService instance();

    public abstract LinkedList<Message> getMessageListFromSchedule(MessageSchedule var1);

    @Override
    public void initialize() {
        File configFile;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String configDirPath = Services.PLATFORM.getGameDirectory() + File.separator + "config";
        File configDir = new File(configDirPath);
        if (!configDir.isDirectory()) {
            configDir.mkdirs();
        }
        if (!(configFile = new File(configDirPath + File.separator + "automessage-" + this.environment() + ".json")).isFile()) {
            Constants.LOG.info("{} No config file found. Creating and reloading.", (Object)this.prefix());
            MessageServiceUtil.copyResourceToFile("/assets/automessage/" + this.environment() + "_default.json", configFile);
            File configMessagesFile = new File(configDirPath + File.separator + "messages" + File.separator + this.environment() + "_messages.json");
            MessageServiceUtil.copyResourceToFile("/assets/automessage/" + this.environment() + "_messages.json", configMessagesFile);
            this.initialize();
            return;
        }
        if (configFile.isFile()) {
            Constants.LOG.info("{} Attempting to read {}", (Object)this.prefix(), (Object)configFile.getName());
            try (FileReader reader = new FileReader(configFile);){
                if (this.instance() == null) {
                    if (this.environment().equalsIgnoreCase("client")) {
                        ClientMessageService.instance = (ClientMessageService)gson.fromJson((Reader)reader, ClientMessageService.class);
                        System.out.println("Enabled? " + ClientMessageService.instance.general.enabled);
                    } else if (this.environment().equalsIgnoreCase("server")) {
                        ServerMessageService.instance = (ServerMessageService)gson.fromJson((Reader)reader, ServerMessageService.class);
                        System.out.println("Enabled? " + ServerMessageService.instance.general.enabled);
                    }
                }
            }
            catch (IOException e) {
                Constants.LOG.info("{} Failed to read: {}", (Object)this.prefix(), (Object)configFile.getName());
                Constants.LOG.info(e.toString());
                Constants.LOG.info("{} Using default configuration messages.", (Object)this.prefix());
                e.fillInStackTrace();
            }
            if (this.instance().getMessageJsonFiles() == null) {
                Constants.LOG.info("{} Service JSON has NULL value for \"message_json_files\": {}", (Object)this.prefix(), (Object)configFile.getName());
                return;
            }
            if (this.instance().getMessageJsonFiles().isEmpty()) {
                Constants.LOG.info("{} No message files listed in configuration: {}", (Object)this.prefix(), (Object)configFile.getName());
                return;
            }
            for (String pattern : this.instance().getMessageJsonFiles()) {
                ArrayList<File> filesToLoad = pattern.contains("*") ? MessageServiceUtil.resolveMessagePaths(pattern) : List.of(new File("config", pattern));
                AtomicInteger atomicInteger = new AtomicInteger(0);
                for (File file : filesToLoad) {
                    if (file.exists()) {
                        try (FileReader msgReader = new FileReader(file);){
                            Type listType = new TypeToken<List<Message>>(){}.getType();
                            List loaded = (List)gson.fromJson((Reader)msgReader, listType);
                            loaded.forEach(message -> {
                                if (message.text.contains("\u00a7")) {
                                    message.text = message.text.replaceAll("\u00a7", "\u00a7");
                                }
                                this.instance().getMessageListFromSchedule(message.schedule).add((Message)message);
                                atomicInteger.incrementAndGet();
                            });
                        }
                        catch (Exception e) {
                            Constants.LOG.info("{} Failed to load message file: {}", (Object)this.prefix(), (Object)file.getPath());
                            Constants.LOG.info(e.toString());
                            e.fillInStackTrace();
                        }
                        continue;
                    }
                    Constants.LOG.info("{} Message file not found: {}", (Object)this.prefix(), (Object)file.getPath());
                }
                Constants.LOG.info("{} Message Service loaded {} messages", (Object)this.prefix(), (Object)atomicInteger.get());
            }
        }
    }

    public static class GeneralConfig {
        public boolean enabled = true;
    }
}

