/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.automessage;

import fabric.com.cursee.automessage.AutoMessage;
import fabric.com.cursee.automessage.Constants;
import fabric.com.cursee.automessage.core.ClientMessageService;
import fabric.com.cursee.automessage.core.data.ClientMessages;
import fabric.com.cursee.automessage.core.message.Message;
import fabric.com.cursee.automessage.core.message.MessageServiceUtil;
import fabric.com.cursee.automessage.core.message.MessageType;
import fabric.com.cursee.automessage.core.util.JsonFileHelper;
import fabric.com.cursee.automessage.platform.Services;
import java.io.File;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;

public class AutoMessageClient {
    public static class_310 CLIENT = null;
    private static final String AUTOMESSAGE_DATA_DIR_FILEPATH = Services.PLATFORM.getGameDirectory() + File.separator + "automessage_data";
    private static final String CLIENT_SERVER_TAGS_FILEPATH = Services.PLATFORM.getGameDirectory() + File.separator + "automessage_data" + File.separator + "client_server_tags.json";

    public static void init(class_310 client) {
        CLIENT = client;
        new ClientMessageService().load();
        if (AutoMessage.checkFileExisted) {
            return;
        }
        File autoMessageDataDirectory = new File(AUTOMESSAGE_DATA_DIR_FILEPATH);
        if (!autoMessageDataDirectory.isDirectory()) {
            autoMessageDataDirectory.mkdirs();
        }
        if (JsonFileHelper.hasTag(CLIENT_SERVER_TAGS_FILEPATH, "World Name", "your_message_identifier.firstJoin") && JsonFileHelper.hasTag(CLIENT_SERVER_TAGS_FILEPATH, "127.0.0.1", "your_message_identifier.firstJoin")) {
            return;
        }
        JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, "World Name", "your_message_identifier.firstJoin");
        JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, "127.0.0.1", "your_message_identifier.firstJoin");
    }

    public static String worldNameOrServerIP() {
        Object s;
        if (CLIENT == null) {
            throw new IllegalStateException("Attempted to get world name or server IP address from NULL client");
        }
        if (CLIENT.method_1496()) {
            MinecraftServer server = (MinecraftServer)Objects.requireNonNull(CLIENT.method_1576());
            s = server.method_27050(class_5218.field_24182).toString();
            s = ((String)s).replaceAll("(?s)^.*?(?=" + server.method_27728().method_150() + ")", "").replace(File.separatorChar + "playerdata", "");
        } else {
            s = Objects.requireNonNull(AutoMessageClient.CLIENT.method_1558()).field_3761 + Objects.requireNonNull(AutoMessageClient.CLIENT.method_1558()).field_3752;
        }
        System.out.println("Attempted to return worldNameOrServerIP with value: " + (String)s);
        return s;
    }

    public static void onFirstJoin(class_746 player, class_638 level) {
        ClientMessages.ON_FIRST_JOIN_MESSAGES.forEach(message -> {
            boolean anyKeyContainsTag = JsonFileHelper.anyKeyContainsTag(new File(CLIENT_SERVER_TAGS_FILEPATH), message.identifier + ".firstJoin");
            if (message.pack_intro && anyKeyContainsTag) {
                Constants.LOG.info("Message with identifier {} is marked as a modpack introduction and has already been displayed to {}, skipping.", (Object)message.identifier, (Object)player.method_5820());
                return;
            }
            AutoMessageClient.trySendMessageOnce((class_1657)player, message, "firstJoin");
        });
    }

    public static void onJoinLevel(class_746 player, class_638 level) {
        ClientMessages.ON_JOIN_LEVEL_MESSAGES.forEach(message -> AutoMessageClient.trySendMessageOnce((class_1657)player, message, "join"));
    }

    public static void onDeath(class_746 player, class_638 level) {
        ClientMessages.ON_DEATH_MESSAGES.forEach(message -> AutoMessageClient.trySendMessageOnce((class_1657)player, message, "death"));
    }

    public static void onRespawn(class_746 player, class_638 level) {
        ClientMessages.ON_RESPAWN_MESSAGES.forEach(message -> AutoMessageClient.trySendMessageOnce((class_1657)player, message, "respawn"));
    }

    public static void trySendMessageOnce(class_1657 player, Message message, String suffix) {
        if (!ClientMessageService.instance.general.enabled) {
            return;
        }
        String serverName = AutoMessageClient.worldNameOrServerIP();
        boolean hasTag = JsonFileHelper.hasTag(CLIENT_SERVER_TAGS_FILEPATH, serverName, message.identifier + "." + suffix);
        if (message.repeats || !hasTag) {
            player.method_7353(MessageServiceUtil.styledComponent(message, player), message.type == MessageType.OVERLAY);
            if (!message.repeats && !hasTag) {
                JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, serverName, message.identifier + "." + suffix);
            }
        }
    }
}

