/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.automessage;

import common.com.cursee.automessage.core.ServerMessageService;
import common.com.cursee.automessage.core.data.ServerMessages;
import common.com.cursee.automessage.core.message.Message;
import common.com.cursee.automessage.core.message.MessageServiceUtil;
import common.com.cursee.automessage.core.message.MessageType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class AutoMessageServer {
    public static void init(MinecraftServer server) {
        new ServerMessageService().load();
    }

    public static void onFirstJoin(ServerPlayer player, ServerLevel level) {
        ServerMessages.ON_FIRST_JOIN_MESSAGES.forEach(message -> AutoMessageServer.trySendMessageOnce(player, message, "firstJoin"));
    }

    public static void onJoinLevel(ServerPlayer player, ServerLevel level) {
        ServerMessages.ON_JOIN_LEVEL_MESSAGES.forEach(message -> AutoMessageServer.trySendMessageOnce(player, message, "join"));
    }

    public static void onDeath(ServerPlayer player, ServerLevel level) {
        ServerMessages.ON_DEATH_MESSAGES.forEach(message -> AutoMessageServer.trySendMessageOnce(player, message, "death"));
    }

    public static void onRespawn(ServerPlayer player, ServerLevel level) {
        ServerMessages.ON_RESPAWN_MESSAGES.forEach(message -> AutoMessageServer.trySendMessageOnce(player, message, "respawn"));
    }

    public static void trySendMessageOnce(ServerPlayer player, Message message, String suffix) {
        if (!ServerMessageService.instance.general.enabled) {
            return;
        }
        boolean hasTag = player.m_19880_().contains(message.identifier + "." + suffix);
        if (message.repeats || !hasTag) {
            player.m_5661_(MessageServiceUtil.styledComponent(message, (Player)player), message.type == MessageType.OVERLAY);
            if (!hasTag) {
                player.m_20049_(message.identifier + "." + suffix);
            }
        }
    }
}

