/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStatePredicateHelper {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static Predicate<BlockState> variantPredicate(StateDefinition<Block, BlockState> container, String variant) {
        HashMap map = Maps.newHashMap();
        for (String s : COMMA_SPLITTER.split((CharSequence)variant)) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            Property property = container.m_61081_(s1);
            if (property != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Object comparable = BlockStatePredicateHelper.getValueHelper(property, s2);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + String.valueOf(property.m_6908_()));
                }
                map.put(property, comparable);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        Block block = (Block)container.m_61091_();
        return arg2 -> {
            if (arg2 == null || !arg2.m_60713_(block)) {
                return false;
            }
            for (Map.Entry entry : map.entrySet()) {
                if (Objects.equals(arg2.m_61143_((Property)entry.getKey()), entry.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    @Nullable
    private static <T extends Comparable<T>> T getValueHelper(Property<T> property, String value) {
        return (T)((Comparable)property.m_6215_(value).orElse(null));
    }
}

