/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot;

import com.blamejared.crafttweaker.api.loot.modifier.ILootModifier;
import com.blamejared.crafttweaker.impl.loot.CraftTweakerLootModifierAdapter;
import com.blamejared.crafttweaker.impl.loot.ForgeLootModifierAdapter;
import com.blamejared.crafttweaker.impl.loot.ForgeLootModifierMapEntrySetAdapter;
import com.blamejared.crafttweaker.impl.loot.ForgeLootModifierValuesCollectionAdapter;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public final class ForgeLootModifierMapAdapter
extends AbstractMap<ResourceLocation, ILootModifier> {
    private final Map<ResourceLocation, IGlobalLootModifier> wrapped;

    private ForgeLootModifierMapAdapter(Map<ResourceLocation, IGlobalLootModifier> wrapped) {
        this.wrapped = wrapped;
    }

    public static Map<ResourceLocation, ILootModifier> adapt(Map<ResourceLocation, IGlobalLootModifier> map) {
        return new ForgeLootModifierMapAdapter(map);
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof IGlobalLootModifier) {
            return this.wrapped.containsValue(value);
        }
        if (value instanceof ForgeLootModifierAdapter) {
            ForgeLootModifierAdapter wrapper = (ForgeLootModifierAdapter)value;
            return this.wrapped.containsValue(wrapper.modifier());
        }
        return super.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public ILootModifier get(Object key) {
        return ForgeLootModifierAdapter.adapt(this.wrapped.get(key));
    }

    @Override
    public ILootModifier put(ResourceLocation key, ILootModifier value) {
        return ForgeLootModifierAdapter.adapt(this.wrapped.put(key, CraftTweakerLootModifierAdapter.adapt(value)));
    }

    @Override
    public ILootModifier remove(Object key) {
        return ForgeLootModifierAdapter.adapt(this.wrapped.remove(key));
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    @Nonnull
    public Set<ResourceLocation> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    @Nonnull
    public Collection<ILootModifier> values() {
        return ForgeLootModifierValuesCollectionAdapter.adapt(this.wrapped.values());
    }

    @Override
    @Nonnull
    public Set<Map.Entry<ResourceLocation, ILootModifier>> entrySet() {
        return ForgeLootModifierMapEntrySetAdapter.adapt(this.wrapped.entrySet());
    }
}

