/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.event.bus;

import com.blamejared.crafttweaker.api.event.Phase;
import com.blamejared.crafttweaker.api.event.bus.BusHandlingException;
import com.blamejared.crafttweaker.api.event.bus.IEventBus;
import com.blamejared.crafttweaker.api.event.bus.IEventBusWire;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.google.common.reflect.TypeToken;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class CommonAdaptingEventBusWire<P, C>
implements IEventBusWire {
    private static final CommonToPlatformConverter<?, ?> NOTHING = (a, b) -> {};
    private final IEventBusWire delegate;
    private final IEventBus<C> commonBus;
    private final PlatformToCommonConverter<P, C> platformToCommon;
    private final CommonToPlatformConverter<C, P> commonToPlatform;

    private CommonAdaptingEventBusWire(IEventBusWire delegate, IEventBus<C> commonBus, PlatformToCommonConverter<P, C> platformToCommon, CommonToPlatformConverter<C, P> commonToPlatform) {
        this.delegate = delegate;
        this.commonBus = commonBus;
        this.platformToCommon = platformToCommon;
        this.commonToPlatform = commonToPlatform;
    }

    public static <C, P> IEventBusWire of(IEventBusWire delegate, IEventBus<C> commonBus, Function<P, C> platformToCommon) {
        return CommonAdaptingEventBusWire.of(delegate, commonBus, platformToCommon, (BiConsumer)GenericUtil.uncheck(NOTHING));
    }

    public static <C, P> IEventBusWire of(IEventBusWire delegate, IEventBus<C> commonBus, Function<P, C> platformToCommon, BiConsumer<C, P> commonToPlatform) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(commonBus, "commonBus");
        Objects.requireNonNull(platformToCommon, "platformToCommon");
        Objects.requireNonNull(commonToPlatform, "commonToPlatform");
        return new CommonAdaptingEventBusWire<P, C>(delegate, commonBus, platformToCommon::apply, commonToPlatform::accept);
    }

    @Override
    public <T> void registerBusForDispatch(TypeToken<T> eventType, IEventBus<T> bus) {
        this.delegate.registerBusForDispatch(eventType, bus);
        this.setUpListenerRedirector(bus);
    }

    private <T> void setUpListenerRedirector(IEventBus<T> bus) {
        for (Phase phase : Phase.values()) {
            ListenerRedirector<P, C> consumer = new ListenerRedirector<P, C>(phase, this.commonBus, this.platformToCommon, this.commonToPlatform);
            bus.registerHandler(phase, true, (Consumer)GenericUtil.uncheck(consumer));
        }
    }

    @FunctionalInterface
    private static interface PlatformToCommonConverter<Q, D>
    extends Function<Q, D> {
    }

    @FunctionalInterface
    private static interface CommonToPlatformConverter<D, Q>
    extends BiConsumer<D, Q> {
    }

    private record ListenerRedirector<Q, D>(Phase phase, IEventBus<D> commonBus, PlatformToCommonConverter<Q, D> platformToCommon, CommonToPlatformConverter<D, Q> commonToPlatform) implements Consumer<Q>
    {
        @Override
        public void accept(Q platform) {
            Object common = this.platformToCommon().apply(platform);
            this.commonBus().postCatching(this.phase(), common, this::rethrow);
            this.commonToPlatform().accept(common, platform);
        }

        private void rethrow(BusHandlingException e) {
            throw e;
        }
    }
}

