/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.core.registry;

import com.starfish_studios.naturalist.common.block.AlligatorEggBlock;
import com.starfish_studios.naturalist.common.block.ChrysalisBlock;
import com.starfish_studios.naturalist.common.block.GlowGoopBlock;
import com.starfish_studios.naturalist.common.block.SnailEggBlock;
import com.starfish_studios.naturalist.common.block.TeddyBearBlock;
import com.starfish_studios.naturalist.common.block.TortoiseEggBlock;
import com.starfish_studios.naturalist.common.entity.Butterfly;
import com.starfish_studios.naturalist.common.entity.Snail;
import com.starfish_studios.naturalist.common.item.DuckEggItem;
import com.starfish_studios.naturalist.common.item.GlowGoopItem;
import com.starfish_studios.naturalist.core.platform.CommonPlatformHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;

public class NaturalistRegistry {
    public static final Supplier<Item> BUSHMEAT = CommonPlatformHelper.registerItem("bushmeat", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(3).m_38757_().m_38767_())));
    public static final Supplier<Item> COOKED_BUSHMEAT = CommonPlatformHelper.registerItem("cooked_bushmeat", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(8).m_38757_().m_38767_())));
    public static final Supplier<Item> FUR = CommonPlatformHelper.registerItem("fur", () -> new Item(new Item.Properties()));
    public static final Supplier<Block> ALLIGATOR_EGG = NaturalistRegistry.registerBlock("alligator_egg", () -> new AlligatorEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50578_)));
    public static final Supplier<Item> DUCK_EGG = CommonPlatformHelper.registerItem("duck_egg", () -> new DuckEggItem(new Item.Properties()));
    public static final Supplier<Block> TORTOISE_EGG = NaturalistRegistry.registerBlock("tortoise_egg", () -> new TortoiseEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50578_)));
    public static final Supplier<Item> COOKED_EGG = CommonPlatformHelper.registerItem("cooked_egg", () -> new Item(new Item.Properties().m_41489_(Foods.f_38815_)));
    public static final Supplier<Block> SNAIL_EGGS = NaturalistRegistry.registerBlock("snail_eggs", () -> new SnailEggBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220862_)));
    public static final Supplier<Item> ANTLER = CommonPlatformHelper.registerItem("antler", () -> new Item(new Item.Properties()));
    public static final Supplier<Block> GLOW_GOOP_BLOCK = NaturalistRegistry.registerBlockOnly("glow_goop", () -> new GlowGoopBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_280170_().m_60955_().m_60910_().m_60953_(GlowGoopBlock.LIGHT_EMISSION).m_60918_(SoundType.f_56751_)));
    public static final Supplier<Item> GLOW_GOOP = CommonPlatformHelper.registerItem("glow_goop", () -> new GlowGoopItem(GLOW_GOOP_BLOCK.get(), new Item.Properties()));
    public static final Supplier<Block> TEDDY_BEAR = NaturalistRegistry.registerBlock("teddy_bear", () -> new TeddyBearBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.8f).m_60918_(SoundType.f_56745_).m_60955_()));
    public static final Supplier<Item> DUCK = CommonPlatformHelper.registerItem("duck", () -> new Item(new Item.Properties().m_41489_(Foods.f_38817_)));
    public static final Supplier<Item> COOKED_DUCK = CommonPlatformHelper.registerItem("cooked_duck", () -> new Item(new Item.Properties().m_41489_(Foods.f_38821_)));
    public static final Supplier<Item> VENISON = CommonPlatformHelper.registerItem("venison", () -> new Item(new Item.Properties().m_41489_(Foods.f_38835_)));
    public static final Supplier<Item> COOKED_VENISON = CommonPlatformHelper.registerItem("cooked_venison", () -> new Item(new Item.Properties().m_41489_(Foods.f_38823_)));
    public static final Supplier<Item> LIZARD_TAIL = CommonPlatformHelper.registerItem("lizard_tail", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.8f).m_38757_().m_38762_(new MobEffectInstance(MobEffects.f_19614_, 100, 0), 1.0f).m_38767_())));
    public static final Supplier<Item> COOKED_LIZARD_TAIL = CommonPlatformHelper.registerItem("cooked_lizard_tail", () -> new Item(new Item.Properties().m_41489_(Foods.f_38811_)));
    public static final Supplier<Item> CATFISH_BUCKET = CommonPlatformHelper.registerMobBucketItem("catfish_bucket", NaturalistEntityTypes.CATFISH, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_);
    public static final Supplier<Item> BASS_BUCKET = CommonPlatformHelper.registerMobBucketItem("bass_bucket", NaturalistEntityTypes.BASS, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_);
    public static final Supplier<Item> CATFISH = CommonPlatformHelper.registerItem("catfish", () -> new Item(new Item.Properties().m_41489_(Foods.f_38805_)));
    public static final Supplier<Item> COOKED_CATFISH = CommonPlatformHelper.registerItem("cooked_catfish", () -> new Item(new Item.Properties().m_41489_(Foods.f_38826_)));
    public static final Supplier<Item> BASS = CommonPlatformHelper.registerItem("bass", () -> new Item(new Item.Properties().m_41489_(Foods.f_38819_)));
    public static final Supplier<Item> COOKED_BASS = CommonPlatformHelper.registerItem("cooked_bass", () -> new Item(new Item.Properties().m_41489_(Foods.f_38822_)));
    public static final Supplier<Item> BUG_NET = CommonPlatformHelper.registerItem("bug_net", () -> new Item(new Item.Properties().m_41503_(64)));
    public static final Supplier<Block> CHRYSALIS_BLOCK = NaturalistRegistry.registerBlockOnly("chrysalis", () -> new ChrysalisBlock(BlockBehaviour.Properties.m_284310_().m_60977_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56740_).m_60955_().m_60910_().m_278166_(PushReaction.DESTROY)));
    public static final Supplier<Item> CHRYSALIS = CommonPlatformHelper.registerItem("chrysalis", () -> new BlockItem(CHRYSALIS_BLOCK.get(), new Item.Properties().m_41487_(1)));
    public static final Supplier<Item> CATERPILLAR = CommonPlatformHelper.registerCaughtMobItem("caterpillar", NaturalistEntityTypes.CATERPILLAR, () -> Fluids.f_76191_, NaturalistSoundEvents.SNAIL_FORWARD);
    public static final Supplier<Item> BUTTERFLY = CommonPlatformHelper.registerCaughtMobItem("butterfly", NaturalistEntityTypes.BUTTERFLY, () -> Fluids.f_76191_, NaturalistSoundEvents.BIRD_FLY, Butterfly.Variant.values().length);
    public static final Supplier<Item> SNAIL_SHELL = CommonPlatformHelper.registerItem("snail_shell", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> SNAIL_BUCKET = CommonPlatformHelper.registerNoFluidMobBucketItem("snail_bucket", NaturalistEntityTypes.SNAIL, () -> Fluids.f_76191_, NaturalistSoundEvents.BUCKET_EMPTY_SNAIL, Snail.Color.values().length);
    public static final Supplier<Block> AZURE_FROGLASS = NaturalistRegistry.registerBlock("azure_froglass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)));
    public static final Supplier<Block> VERDANT_FROGLASS = NaturalistRegistry.registerBlock("verdant_froglass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)));
    public static final Supplier<Block> CRIMSON_FROGLASS = NaturalistRegistry.registerBlock("crimson_froglass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)));
    public static final Supplier<Block> AZURE_FROGLASS_PANE = NaturalistRegistry.registerBlock("azure_froglass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_)));
    public static final Supplier<Block> VERDANT_FROGLASS_PANE = NaturalistRegistry.registerBlock("verdant_froglass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_)));
    public static final Supplier<Block> CRIMSON_FROGLASS_PANE = NaturalistRegistry.registerBlock("crimson_froglass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_)));
    public static final Supplier<Block> SHELLSTONE = NaturalistRegistry.registerBlock("shellstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SHELLSTONE_STAIRS = NaturalistRegistry.registerBlock("shellstone_stairs", () -> new StairBlock(SHELLSTONE.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SHELLSTONE_SLAB = NaturalistRegistry.registerBlock("shellstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SHELLSTONE_WALL = NaturalistRegistry.registerBlock("shellstone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SHELLSTONE_BRICKS = NaturalistRegistry.registerBlock("shellstone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SHELLSTONE_BRICK_STAIRS = NaturalistRegistry.registerBlock("shellstone_brick_stairs", () -> new StairBlock(SHELLSTONE_BRICKS.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SHELLSTONE_BRICK_SLAB = NaturalistRegistry.registerBlock("shellstone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SHELLSTONE_BRICK_WALL = NaturalistRegistry.registerBlock("shellstone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> CUT_SHELLSTONE = NaturalistRegistry.registerBlock("cut_shellstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> CUT_SHELLSTONE_STAIRS = NaturalistRegistry.registerBlock("cut_shellstone_stairs", () -> new StairBlock(CUT_SHELLSTONE.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> CUT_SHELLSTONE_SLAB = NaturalistRegistry.registerBlock("cut_shellstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> CUT_SHELLSTONE_WALL = NaturalistRegistry.registerBlock("cut_shellstone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SMOOTH_SHELLSTONE = NaturalistRegistry.registerBlock("smooth_shellstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SMOOTH_SHELLSTONE_STAIRS = NaturalistRegistry.registerBlock("smooth_shellstone_stairs", () -> new StairBlock(SMOOTH_SHELLSTONE.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SMOOTH_SHELLSTONE_SLAB = NaturalistRegistry.registerBlock("smooth_shellstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<Block> SMOOTH_SHELLSTONE_WALL = NaturalistRegistry.registerBlock("smooth_shellstone_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final Supplier<SpawnEggItem> ALLIGATOR_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("alligator_spawn_egg", NaturalistEntityTypes.ALLIGATOR, 6184228, 13810273);
    public static final Supplier<SpawnEggItem> BASS_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("bass_spawn_egg", NaturalistEntityTypes.BASS, 8159273, 14729339);
    public static final Supplier<SpawnEggItem> BEAR_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("bear_spawn_egg", NaturalistEntityTypes.BEAR, 6569255, 13150577);
    public static final Supplier<SpawnEggItem> BLUEJAY_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("bluejay_spawn_egg", NaturalistEntityTypes.BLUEJAY, 2830129, 4289464);
    public static final Supplier<SpawnEggItem> BOAR_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("boar_spawn_egg", NaturalistEntityTypes.BOAR, 6768433, 9854549);
    public static final Supplier<SpawnEggItem> BUTTERFLY_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("butterfly_spawn_egg", NaturalistEntityTypes.BUTTERFLY, 15165706, 6828564);
    public static final Supplier<SpawnEggItem> CANARY_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("canary_spawn_egg", NaturalistEntityTypes.CANARY, 16704333, 13999625);
    public static final Supplier<SpawnEggItem> CARDINAL_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("cardinal_spawn_egg", NaturalistEntityTypes.CARDINAL, 0xD22828, 0x442222);
    public static final Supplier<SpawnEggItem> CATFISH_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("catfish_spawn_egg", NaturalistEntityTypes.CATFISH, 8416033, 12233092);
    public static final Supplier<SpawnEggItem> CATERPILLAR_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("caterpillar_spawn_egg", NaturalistEntityTypes.CATERPILLAR, 3815473, 15647488);
    public static final Supplier<SpawnEggItem> CORAL_SNAKE_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("coral_snake_spawn_egg", NaturalistEntityTypes.CORAL_SNAKE, 3485226, 12261376);
    public static final Supplier<SpawnEggItem> DEER_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("deer_spawn_egg", NaturalistEntityTypes.DEER, 10318165, 14531208);
    public static final Supplier<SpawnEggItem> DRAGONFLY_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("dragonfly_spawn_egg", NaturalistEntityTypes.DRAGONFLY, 7507200, 16771840);
    public static final Supplier<SpawnEggItem> DUCK_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("duck_spawn_egg", NaturalistEntityTypes.DUCK, 0xCABBAB, 2333491);
    public static final Supplier<SpawnEggItem> ELEPHANT_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("elephant_spawn_egg", NaturalistEntityTypes.ELEPHANT, 9539213, 6643034);
    public static final Supplier<SpawnEggItem> FINCH_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("finch_spawn_egg", NaturalistEntityTypes.FINCH, 12013877, 6576975);
    public static final Supplier<SpawnEggItem> FIREFLY_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("firefly_spawn_egg", NaturalistEntityTypes.FIREFLY, 6764577, 16768800);
    public static final Supplier<SpawnEggItem> GIRAFFE_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("giraffe_spawn_egg", NaturalistEntityTypes.GIRAFFE, 14329967, 7619616);
    public static final Supplier<SpawnEggItem> HIPPO_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("hippo_spawn_egg", NaturalistEntityTypes.HIPPO, 15702682, 9004386);
    public static final Supplier<SpawnEggItem> LION_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("lion_spawn_egg", NaturalistEntityTypes.LION, 14990722, 6699537);
    public static final Supplier<SpawnEggItem> LIZARD_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("lizard_spawn_egg", NaturalistEntityTypes.LIZARD, 10853166, 0xEFEFAE);
    public static final Supplier<SpawnEggItem> RATTLESNAKE_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("rattlesnake_spawn_egg", NaturalistEntityTypes.RATTLESNAKE, 16039772, 7293214);
    public static final Supplier<SpawnEggItem> RHINO_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("rhino_spawn_egg", NaturalistEntityTypes.RHINO, 7626842, 10982025);
    public static final Supplier<SpawnEggItem> ROBIN_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("robin_spawn_egg", NaturalistEntityTypes.ROBIN, 4865860, 16620592);
    public static final Supplier<SpawnEggItem> SNAKE_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("snake_spawn_egg", NaturalistEntityTypes.SNAKE, 8813107, 15524255);
    public static final Supplier<SpawnEggItem> SNAIL_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("snail_spawn_egg", NaturalistEntityTypes.SNAIL, 5457209, 8811878);
    public static final Supplier<SpawnEggItem> SPARROW_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("sparrow_spawn_egg", NaturalistEntityTypes.SPARROW, 6504493, 14603707);
    public static final Supplier<SpawnEggItem> TORTOISE_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("tortoise_spawn_egg", NaturalistEntityTypes.TORTOISE, 0xEFEFAE, 11765582);
    public static final Supplier<SpawnEggItem> VULTURE_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("vulture_spawn_egg", NaturalistEntityTypes.VULTURE, 4010022, 15325376);
    public static final Supplier<SpawnEggItem> ZEBRA_SPAWN_EGG = CommonPlatformHelper.registerSpawnEggItem("zebra_spawn_egg", NaturalistEntityTypes.ZEBRA, 15263457, 0x1A1818);

    public static List<ItemStack> collectAllItemStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        try {
            Field[] fields;
            for (Field field : fields = NaturalistRegistry.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Supplier.class.isAssignableFrom(field.getType())) continue;
                Supplier supplier = (Supplier)field.get(null);
                Object value = supplier.get();
                if (value instanceof Block) {
                    Block block = (Block)value;
                    if (block == GLOW_GOOP_BLOCK.get() || block == CHRYSALIS_BLOCK.get()) continue;
                    stacks.add(new ItemStack((ItemLike)block));
                    continue;
                }
                if (!(value instanceof Item)) continue;
                Item item = (Item)value;
                stacks.add(new ItemStack((ItemLike)item));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return stacks;
    }

    public static void init() {
    }

    public static <T extends Block> Supplier<T> registerBlock(String name, Supplier<T> block) {
        Supplier supplier = CommonPlatformHelper.registerBlock(name, block);
        CommonPlatformHelper.registerItem(name, () -> new BlockItem((Block)supplier.get(), new Item.Properties()));
        return supplier;
    }

    public static <T extends Block> Supplier<T> registerBlockOnly(String name, Supplier<T> block) {
        return CommonPlatformHelper.registerBlock(name, block);
    }

    public static void addAllToCreativeTab() {
        Field[] fields;
        for (Field field : fields = NaturalistRegistry.class.getDeclaredFields()) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Type rawType = type.getRawType();
            Type[] typeArguments = type.getActualTypeArguments();
            if (rawType != Supplier.class || typeArguments.length != 1) continue;
            Class arg = (Class)typeArguments[0];
            if (Block.class.isAssignableFrom(arg)) {
                NaturalistRegistry.addAllToCreativeTab();
                continue;
            }
            if (!Item.class.isAssignableFrom(arg) && !SpawnEggItem.class.isAssignableFrom(arg)) continue;
            NaturalistRegistry.addAllToCreativeTab();
        }
    }
}

