/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.events;

import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.cap.ShrinkImpl;
import net.gigabit101.shrink.config.ShrinkConfig;
import net.gigabit101.shrink.items.ItemModBottle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="shrink", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEvents {
    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone evt) {
        evt.getOriginal().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(old -> {
            CompoundTag compoundTag = (CompoundTag)old.serializeNBT();
            evt.getEntity().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.deserializeNBT((Tag)compoundTag));
        });
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent evt) {
        evt.getEntity().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.sync((LivingEntity)evt.getEntity()));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        event.getEntity().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.sync((LivingEntity)event.getEntity()));
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<Entity> evt) {
        Object object = evt.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)object;
            try {
                evt.addCapability(ShrinkImpl.Provider.NAME, (ICapabilityProvider)new ShrinkImpl.Provider(livingEntity));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.sync((LivingEntity)player));
    }

    @SubscribeEvent
    public static void playerStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> iShrinkProvider.sync(livingEntity));
        }
    }

    @SubscribeEvent
    public static void joinWorldEvent(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_6210_();
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> iShrinkProvider.sync(livingEntity));
        }
    }

    @SubscribeEvent
    public static void itemInteractionForEntity(PlayerInteractEvent.EntityInteract event) {
        if (!((Boolean)ShrinkConfig.ENABLE_MOB_BOTTLES.get()).booleanValue()) {
            return;
        }
        if (!event.getLevel().m_5776_() && event.getTarget() instanceof LivingEntity && !(event.getTarget() instanceof Player)) {
            Player playerEntity = event.getEntity();
            Entity entity = event.getTarget();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (playerEntity.m_21120_(event.getHand()).m_41720_() == Items.f_42590_) {
                    livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                        if (iShrinkProvider.isShrunk()) {
                            playerEntity.m_21120_(event.getHand()).m_41774_(1);
                            ItemStack output = ItemModBottle.setContainedEntity(event.getItemStack(), livingEntity);
                            boolean added = playerEntity.m_150109_().m_36054_(output);
                            if (!added) {
                                ItemEntity itemEntity = new ItemEntity(event.getLevel(), (double)playerEntity.m_20183_().m_123341_(), (double)playerEntity.m_20183_().m_123342_(), (double)playerEntity.m_20183_().m_123343_(), output);
                                event.getLevel().m_7967_((Entity)itemEntity);
                            }
                        }
                    });
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void changeSize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                if (iShrinkProvider.isShrunk()) {
                    event.setNewSize(event.getNewSize().m_20388_(iShrinkProvider.scale()));
                    event.setNewEyeHeight(event.getNewEyeHeight() * iShrinkProvider.scale());
                }
            });
        }
    }
}

