/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects.items;

import com.mcwbridges.kikoz.objects.Bridge_Block;
import com.mcwbridges.kikoz.objects.Bridge_Block_Rope;
import com.mcwbridges.kikoz.objects.Bridge_Stairs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Bridge_Torch
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<LightState> LIGHTSTATE = EnumProperty.m_61587_((String)"lightstate", LightState.class);
    protected static final VoxelShape EAST = Block.m_49796_((double)6.2, (double)0.0, (double)0.0, (double)9.8, (double)8.0, (double)2.8);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)13.2, (double)0.0, (double)6.2, (double)16.0, (double)8.0, (double)9.8);
    protected static final VoxelShape WEST = Block.m_49796_((double)6.2, (double)0.0, (double)13.2, (double)9.8, (double)8.0, (double)16.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)6.2, (double)2.8, (double)8.0, (double)9.8);
    protected static final VoxelShape EAST_STAIR = Block.m_49796_((double)6.2, (double)6.0, (double)0.0, (double)9.8, (double)16.0, (double)2.8);
    protected static final VoxelShape SOUTH_STAIR = Block.m_49796_((double)13.2, (double)6.0, (double)6.2, (double)16.0, (double)16.0, (double)9.8);
    protected static final VoxelShape WEST_STAIR = Block.m_49796_((double)6.2, (double)6.0, (double)13.2, (double)9.8, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_STAIR = Block.m_49796_((double)0.0, (double)6.0, (double)6.2, (double)2.8, (double)16.0, (double)9.8);
    protected int lightValue;

    public Bridge_Torch(BlockBehaviour.Properties prop, int lightValue) {
        super(prop);
        this.lightValue = lightValue;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(LIGHTSTATE, (Comparable)((Object)LightState.BRIDGE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        LightState lightState = (LightState)((Object)state.m_61143_(LIGHTSTATE));
        if (lightState == LightState.BRIDGE) {
            switch (facing) {
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
            }
            return EAST;
        }
        switch (facing) {
            case NORTH: {
                return NORTH_STAIR;
            }
            case SOUTH: {
                return SOUTH_STAIR;
            }
            case WEST: {
                return WEST_STAIR;
            }
        }
        return EAST_STAIR;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        return Shapes.m_83040_();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean bool) {
        if (fromPos.m_7494_().equals((Object)pos) && !level.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)level, pos.m_7495_())) {
            level.m_46961_(pos, true);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.lightValue;
    }

    public int getLightValue(BlockState state, BlockGetter reader, BlockPos pos) {
        return 15;
    }

    public float getAmbientOcclusionLightValue(BlockState state, BlockGetter reader, BlockPos pos) {
        return 1.0f;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIGHTSTATE});
    }

    public BlockState m_5573_(BlockPlaceContext contx) {
        BlockPos belowPos = contx.m_8083_().m_7495_();
        BlockState belowState = contx.m_43725_().m_8055_(belowPos);
        BlockState state = belowState.m_60734_() instanceof Bridge_Block ? this.handleBridgeBlockPlacement(belowState) : (belowState.m_60734_() instanceof Bridge_Block_Rope ? this.handleBridgeBlockRopePlacement(belowState) : (belowState.m_60734_() instanceof Bridge_Stairs ? this.handleBridgeStairsPlacement(belowState) : (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)contx.m_8125_().m_122427_())));
        return state != null ? (BlockState)state.m_61124_(LIGHTSTATE, (Comparable)((Object)LightState.byState(belowState))) : null;
    }

    private BlockState handleBridgeBlockPlacement(BlockState belowState) {
        Bridge_Block.ConnectionStatus connectionStatus = (Bridge_Block.ConnectionStatus)((Object)belowState.m_61143_(Bridge_Block.CONNECTION));
        switch (connectionStatus) {
            case BASE: {
                return null;
            }
            case SIDE_E: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH);
            }
            case SIDE_N: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            case SIDE_S: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST);
            }
            case SIDE_W: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_EW: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_NS: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            case CORNER_NE: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case CORNER_NW: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST);
            }
            case CORNER_SE: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case CORNER_SW: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
        }
        return this.m_49966_();
    }

    private BlockState handleBridgeBlockRopePlacement(BlockState belowState) {
        Bridge_Block_Rope.ConnectionStatus connectionStatus = (Bridge_Block_Rope.ConnectionStatus)((Object)belowState.m_61143_(Bridge_Block_Rope.CONNECTION));
        switch (connectionStatus) {
            case BASE: 
            case BASE_TOGGLED: {
                return null;
            }
            case SIDE_E: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH);
            }
            case SIDE_N: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            case SIDE_S: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST);
            }
            case SIDE_W: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_EW: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_NS: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            case CORNER_NE: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case CORNER_NW: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST);
            }
            case CORNER_SE: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case CORNER_SW: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            case MIDDLE_END_N: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_END_E: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            case MIDDLE_END_S: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case MIDDLE_END_W: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            case END_E_LEFT: 
            case END_E_RIGHT: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
            }
            case END_N_LEFT: 
            case END_N_RIGHT: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH);
            }
            case END_S_LEFT: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST);
            }
            case END_S_RIGHT: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            case END_W_LEFT: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.EAST);
            }
            case END_W_RIGHT: {
                return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.WEST);
            }
        }
        return this.m_49966_();
    }

    private BlockState handleBridgeStairsPlacement(BlockState belowState) {
        Bridge_Stairs.ConnectionStatus connectionStatus = (Bridge_Stairs.ConnectionStatus)((Object)belowState.m_61143_(Bridge_Stairs.CONNECTION));
        Direction stairsFacing = (Direction)belowState.m_61143_((Property)Bridge_Stairs.FACING);
        if (connectionStatus == Bridge_Stairs.ConnectionStatus.DOUBLE) {
            return null;
        }
        Direction newFacing = connectionStatus == Bridge_Stairs.ConnectionStatus.LEFT ? this.rotateLeft(stairsFacing) : this.rotateRight(stairsFacing);
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)newFacing);
    }

    private Direction rotateLeft(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
            case WEST: {
                return Direction.SOUTH;
            }
        }
        return facing;
    }

    private Direction rotateRight(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        return facing;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return dir == Direction.DOWN ? (BlockState)state.m_61124_(LIGHTSTATE, (Comparable)((Object)LightState.byState(statetwo))) : super.m_7417_(state, dir, statetwo, access, pos, postwo);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        Direction facing = (Direction)stateIn.m_61143_((Property)FACING);
        double d0 = (double)pos.m_123342_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.9;
        double southX = (double)pos.m_123341_() + 0.5;
        double southZ = (double)pos.m_123343_() + 0.95;
        double northZ = (double)pos.m_123343_() + 0.05;
        double westX = (double)pos.m_123341_() + 0.05;
        double westZ = (double)pos.m_123343_() + 0.5;
        double eastX = (double)pos.m_123341_() + 0.95;
        double eastZ = (double)pos.m_123343_() + 0.5;
        LightState i = (LightState)((Object)stateIn.m_61143_(LIGHTSTATE));
        if (i == LightState.BRIDGE) {
            switch (facing) {
                case EAST: {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, southX, d0, northZ, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, southX, d0, northZ, 0.0, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, southX, d0, southZ, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, southX, d0, southZ, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, westX, d0, westZ, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, westX, d0, westZ, 0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, eastX, d0, eastZ, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, eastX, d0, eastZ, 0.0, 0.0, 0.0);
                }
            }
        } else {
            switch (facing) {
                case EAST: {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, southX, d1, northZ, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, southX, d1, northZ, 0.0, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, southX, d1, southZ, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, southX, d1, southZ, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, westX, d1, westZ, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, westX, d1, westZ, 0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, eastX, d1, eastZ, 0.0, 0.0, 0.0);
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, eastX, d1, eastZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static enum LightState implements StringRepresentable
    {
        BRIDGE("bridge"),
        STAIR("stair");

        private final String name;

        private LightState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static LightState byState(BlockState state) {
            if (state.m_60734_() instanceof Bridge_Stairs) {
                return STAIR;
            }
            return BRIDGE;
        }
    }
}

