/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationModule;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.ModList;

public class IntegrationRegistry {
    private String modId;
    private List<IntegrationModule> registry;

    public IntegrationRegistry(String modId) {
        this.modId = modId;
        this.registry = new ArrayList<IntegrationModule>();
    }

    public void add(IntegrationModule module) {
        if (module.versionCheck()) {
            this.registry.add(module);
        }
    }

    public void init() {
        for (int i = 0; i < this.registry.size(); ++i) {
            IntegrationModule module = this.registry.get(i);
            if (module.getModID() != null && !ModList.get().isLoaded(module.getModID())) {
                this.registry.remove(i--);
                continue;
            }
            try {
                module.init();
                continue;
            }
            catch (Throwable t) {
                this.registry.remove(i--);
                StorageDrawers.log.info("Could not load integration module: " + module.getClass().getName());
            }
        }
    }

    public void postInit() {
        for (IntegrationModule module : this.registry) {
            module.postInit();
        }
    }

    public boolean isModLoaded(String mod_id) {
        for (IntegrationModule module : this.registry) {
            if (!module.getModID().equals(mod_id)) continue;
            return true;
        }
        return false;
    }
}

